/*
 * Copyright 2016, The OpenNMS Group
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.opennms.gizmo.docker;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

import org.opennms.gizmo.GizmoStack;

import com.spotify.docker.client.messages.ContainerConfig;

public interface GizmoDockerStack extends GizmoStack<GizmoDockerStack, GizmoDockerStacker> {

    Map<String, Function<GizmoDockerStacker, ContainerConfig>> getContainersByAlias();

    @Override
    List<Consumer<GizmoDockerStacker>> getWaitingRules();

    void beforeStack(GizmoDockerStacker stacker);

    void afterStack(GizmoDockerStacker stacker);

}
