/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.docker;

import com.google.common.collect.ImmutableMap;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import jersey.repackaged.com.google.common.collect.ImmutableList;
import org.opennms.gizmo.docker.GizmoDockerRule;
import org.opennms.gizmo.docker.GizmoDockerStack;
import org.opennms.gizmo.docker.GizmoDockerStacker;

public class GizmoDockerRuleBuilder {
    protected DockerClient docker;
    protected final Map<String, Function<GizmoDockerStacker, ContainerConfig>> containersByAlias = new LinkedHashMap<String, Function<GizmoDockerStacker, ContainerConfig>>();
    protected final List<Consumer<GizmoDockerStacker>> waitingRules = new LinkedList<Consumer<GizmoDockerStacker>>();
    protected boolean skipPull = false;
    protected boolean skipTearDown = false;
    protected boolean skipTearDownOnFailure = false;
    protected boolean useExistingStacks = false;
    protected List<GizmoDockerStack> stacks = new LinkedList<GizmoDockerStack>();

    public GizmoDockerRuleBuilder withDockerClient(DockerClient docker) {
        this.docker = docker;
        return this;
    }

    public GizmoDockerRuleBuilder withContainer(String alias, Function<GizmoDockerStacker, ContainerConfig> container) {
        this.containersByAlias.put(alias, container);
        return this;
    }

    public GizmoDockerRuleBuilder withWaitingRule(Consumer<GizmoDockerStacker> stacker) {
        this.waitingRules.add(stacker);
        return this;
    }

    public GizmoDockerRuleBuilder withStack(GizmoDockerStack stack) {
        this.stacks.add(stack);
        return this;
    }

    public GizmoDockerRuleBuilder skipPull(boolean skipPull) {
        this.skipPull = skipPull;
        return this;
    }

    public GizmoDockerRuleBuilder skipTearDown(boolean skipTearDown) {
        this.skipTearDown = skipTearDown;
        return this;
    }

    public GizmoDockerRuleBuilder skipTearDownOnFailure(boolean skipTearDownOnFailure) {
        this.skipTearDownOnFailure = skipTearDownOnFailure;
        return this;
    }

    public GizmoDockerRuleBuilder useExistingStacks(boolean useExistingStacks) {
        this.useExistingStacks = useExistingStacks;
        return this;
    }

    public GizmoDockerRule build() {
        if (this.containersByAlias.size() > 0) {
            ImmutableMap containers = ImmutableMap.copyOf(this.containersByAlias);
            ImmutableList rules = ImmutableList.copyOf(this.waitingRules);
            this.stacks.add(new GizmoDockerStack((Map)containers, (List)rules){
                final /* synthetic */ Map val$containers;
                final /* synthetic */ List val$rules;
                {
                    this.val$containers = map;
                    this.val$rules = list;
                }

                public List<GizmoDockerStack> getDependencies() {
                    return Collections.emptyList();
                }

                @Override
                public Map<String, Function<GizmoDockerStacker, ContainerConfig>> getContainersByAlias() {
                    return this.val$containers;
                }

                @Override
                public List<Consumer<GizmoDockerStacker>> getWaitingRules() {
                    return this.val$rules;
                }

                @Override
                public void beforeStack(GizmoDockerStacker stacker) {
                }

                @Override
                public void afterStack(GizmoDockerStacker stacker) {
                }
            });
        }
        if (this.stacks.size() < 1) {
            throw new IllegalStateException("One or more stacks and/or containers are required.");
        }
        return new GizmoDockerRule(new GizmoDockerStacker(this), this);
    }
}

