/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.docker;

import com.google.common.base.Throwables;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.PortBinding;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.opennms.gizmo.GizmoStacker;
import org.opennms.gizmo.docker.GizmoDockerRuleBuilder;
import org.opennms.gizmo.docker.GizmoDockerStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GizmoDockerStacker
implements GizmoStacker<GizmoDockerStack> {
    private static final Logger LOG = LoggerFactory.getLogger(GizmoDockerStacker.class);
    private DockerClient docker;
    private final boolean skipPull;
    private final boolean useExistingStacks;
    private final Set<String> createdContainerIds = new LinkedHashSet<String>();
    private final Map<String, ContainerInfo> containerInfoByAlias = new HashMap<String, ContainerInfo>();

    public GizmoDockerStacker(GizmoDockerRuleBuilder builder) {
        this.docker = builder.docker;
        this.skipPull = builder.skipPull;
        this.useExistingStacks = builder.useExistingStacks;
    }

    public void init() throws DockerCertificateException {
        if (this.docker == null) {
            this.docker = DefaultDockerClient.fromEnv().build();
        }
    }

    public void stack(GizmoDockerStack stack) throws DockerException, InterruptedException {
        for (GizmoDockerStack gizmoDockerStack : stack.getDependencies()) {
            LOG.info("Stacking dependency: {}", (Object)gizmoDockerStack);
            this.stack(gizmoDockerStack);
        }
        stack.beforeStack(this);
        for (Map.Entry entry : stack.getContainersByAlias().entrySet()) {
            String containerId;
            String alias = (String)entry.getKey();
            Function containerFunc = (Function)entry.getValue();
            ContainerConfig container = (ContainerConfig)containerFunc.apply(this);
            if (!this.skipPull) {
                try {
                    this.docker.inspectImage(container.image());
                }
                catch (ImageNotFoundException infe) {
                    LOG.info("Pulling image for alias {}: {}", (Object)alias, (Object)container.image());
                    this.docker.pull(container.image());
                    LOG.info("Done pulling image.");
                }
            }
            if (!this.useExistingStacks) {
                ContainerCreation containerCreation = this.docker.createContainer(container);
                containerId = containerCreation.id();
                this.createdContainerIds.add(containerId);
                this.docker.startContainer(containerId);
            } else {
                containerId = this.docker.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.withStatusRunning()}).stream().filter(c -> Objects.equals(container.image(), c.image())).findFirst().orElseThrow(() -> new IllegalStateException("Could not find runnign container with image: " + container.image())).id();
            }
            ContainerInfo containerInfo = this.docker.inspectContainer(containerId);
            LOG.info("{} has container id: {}", (Object)alias, (Object)containerId);
            if (!containerInfo.state().running().booleanValue()) {
                throw new IllegalStateException("Could not start the " + alias + " container");
            }
            this.containerInfoByAlias.put(alias, containerInfo);
        }
        for (Consumer consumer : stack.getWaitingRules()) {
            try {
                consumer.accept(this);
            }
            catch (Throwable t) {
                LOG.error("waitFor() rule failed. Tearing down.", t);
                throw Throwables.propagate((Throwable)t);
            }
        }
        stack.afterStack(this);
    }

    public void tearDown() {
        for (String containerId : this.createdContainerIds) {
            try {
                LOG.info("Killing container with id: {}", (Object)containerId);
                this.docker.killContainer(containerId);
                try {
                    LOG.info("Removing container with id: {}", (Object)containerId);
                    this.docker.removeContainer(containerId);
                }
                catch (Throwable t) {
                    LOG.info("Failed to remove container with id: {}. The container is likely already be removed.", (Object)containerId);
                }
            }
            catch (DockerException | InterruptedException e) {
                LOG.error("Failed to kill and/or remove container with id: {}", (Object)containerId, (Object)e);
            }
        }
    }

    public Set<String> getAliases() {
        return this.containerInfoByAlias.keySet();
    }

    public ContainerInfo getContainerInfo(String alias) {
        return this.containerInfoByAlias.get(alias);
    }

    public InetSocketAddress getServiceAddress(String alias, int port) {
        return this.getServiceAddress(alias, port, "tcp");
    }

    public InetSocketAddress getServiceAddress(String alias, int port, String type) {
        ContainerInfo info = this.getContainerInfo(alias);
        if (info == null) {
            throw new IllegalArgumentException(String.format("No container found with alias: %s. Available containers include: ", alias, this.containerInfoByAlias.keySet()));
        }
        String portKey = port + "/" + type;
        List bindings = (List)info.networkSettings().ports().get((Object)portKey);
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("No bindings found for port %s on alias: %s. Available ports include: %s", portKey, alias, info.networkSettings().ports().keySet()));
        }
        PortBinding binding = (PortBinding)bindings.iterator().next();
        String host = "0.0.0.0".equals(binding.hostIp()) ? this.docker.getHost() : binding.hostIp();
        return new InetSocketAddress(host, (int)Integer.valueOf(binding.hostPort()));
    }

    public void close() throws IOException {
        if (this.docker == null) {
            LOG.warn("Docker client instance is null. Skipping tear down.");
            return;
        }
        this.docker.close();
    }

    protected DockerClient getDocker() {
        return this.docker;
    }
}

