/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.LinkedList;
import java.util.List;
import org.opennms.gizmo.k8s.GizmoK8sRule;
import org.opennms.gizmo.k8s.GizmoK8sStack;
import org.opennms.gizmo.k8s.GizmoK8sStacker;

public class GizmoK8sRuleBuilder {
    protected KubernetesClient kubernetes;
    protected String namespace = null;
    protected final List<GizmoK8sStack> stacks = new LinkedList<GizmoK8sStack>();
    protected boolean skipTearDown = false;
    protected boolean skipTearDownOnFailure = false;

    public GizmoK8sRuleBuilder withKubernetesClient(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
        return this;
    }

    public GizmoK8sRuleBuilder withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public GizmoK8sRuleBuilder withStack(GizmoK8sStack stack) {
        this.stacks.add(stack);
        return this;
    }

    public GizmoK8sRuleBuilder skipTearDown(boolean skipTearDown) {
        this.skipTearDown = skipTearDown;
        return this;
    }

    public GizmoK8sRuleBuilder skipTearDownOnFailure(boolean skipTearDownOnFailure) {
        this.skipTearDownOnFailure = skipTearDownOnFailure;
        return this;
    }

    public GizmoK8sRule build() {
        if (this.stacks.size() < 1) {
            throw new IllegalStateException("One or more stacks are required.");
        }
        return new GizmoK8sRule(new GizmoK8sStacker(this), this);
    }
}

