/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.k8s;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.opennms.gizmo.GizmoStacker;
import org.opennms.gizmo.k8s.GizmoK8sRuleBuilder;
import org.opennms.gizmo.k8s.GizmoK8sStack;
import org.opennms.gizmo.k8s.portforward.ForwardedPort;
import org.opennms.gizmo.k8s.portforward.KubeCtlPortForwardingStrategy;
import org.opennms.gizmo.k8s.portforward.PortForwardingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GizmoK8sStacker
implements GizmoStacker<GizmoK8sStack> {
    private static final Logger LOG = LoggerFactory.getLogger(GizmoK8sStacker.class);
    private KubernetesClient kubernetes;
    private String namespace;
    private boolean deleteNamespace = false;
    private final PortForwardingStrategy portFwdStrategy = new KubeCtlPortForwardingStrategy();
    private final List<ForwardedPort> fwdedPorts = new LinkedList<ForwardedPort>();

    public GizmoK8sStacker(GizmoK8sRuleBuilder builder) {
        this.kubernetes = builder.kubernetes;
        this.namespace = builder.namespace;
    }

    public void init() {
        if (this.kubernetes == null) {
            this.kubernetes = new DefaultKubernetesClient();
        }
        if (this.namespace == null) {
            this.namespace = "gizmo-" + UUID.randomUUID().toString();
            LOG.info("Creating namespace: {}", (Object)this.namespace);
            this.kubernetes.namespaces().create((Object[])new Namespace[]{((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(this.namespace)).addToLabels("scope", "test")).endMetadata()).build()});
            this.deleteNamespace = true;
        }
    }

    public void stack(GizmoK8sStack stack) {
        for (GizmoK8sStack gizmoK8sStack : stack.getDependencies()) {
            LOG.info("Stacking dependency: {}", (Object)gizmoK8sStack);
            this.stack(gizmoK8sStack);
        }
        stack.create(this, this.kubernetes);
        for (Consumer consumer : stack.getWaitingRules()) {
            try {
                consumer.accept(this);
            }
            catch (Throwable t) {
                LOG.error("waitFor() rule failed. Tearing down.", t);
                throw Throwables.propagate((Throwable)t);
            }
        }
    }

    public void tearDown() {
        if (this.kubernetes == null) {
            LOG.warn("Kubernetes client instance is null. Skipping tear down.");
            return;
        }
        if (this.namespace != null && this.deleteNamespace) {
            LOG.info("Deleting namespace: {}", (Object)this.namespace);
            ((Resource)this.kubernetes.namespaces().withName(this.namespace)).delete();
        }
        for (ForwardedPort fwdedPort : this.fwdedPorts) {
            try {
                LOG.info("Closing forwarded port: {}", (Object)fwdedPort);
                fwdedPort.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close forwarded port: {}", (Object)fwdedPort, (Object)e);
            }
        }
    }

    public void close() throws IOException {
        if (this.kubernetes == null) {
            LOG.warn("Kubernetes client instance is null. Skipping tear down.");
            return;
        }
        this.kubernetes.close();
    }

    public KubernetesClient getClient() {
        return this.kubernetes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<Pod> getPodsWithLabel(String key, String value) {
        return ((PodList)((NonNamespaceOperation)this.kubernetes.pods().inNamespace(this.namespace)).list()).getItems().stream().filter(pod -> value.equals(pod.getMetadata().getLabels().get(key))).collect(Collectors.toList());
    }

    public List<Pod> getPodsWithLabels(Map<String, String> labels) {
        return ((PodList)((NonNamespaceOperation)this.kubernetes.pods().inNamespace(this.namespace)).list()).getItems().stream().filter(p -> {
            Map podLabels = p.getMetadata().getLabels();
            for (Map.Entry label : labels.entrySet()) {
                if (((String)label.getValue()).equals(podLabels.get(label.getKey()))) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public InetSocketAddress portForward(String pod, int remotePort) {
        ForwardedPort fwdedPort = this.portFwdStrategy.portForward(this.namespace, pod, remotePort);
        this.fwdedPorts.add(fwdedPort);
        return fwdedPort.getAddress();
    }

    public OkHttpClient getHttpClient() {
        if (this.kubernetes instanceof DefaultKubernetesClient) {
            return ((DefaultKubernetesClient)this.kubernetes).getHttpClient();
        }
        return null;
    }

    public URL getProxyUrl(String service, String ... parts) {
        try {
            URL baseUrl = new URL(URLUtils.join((String[])new String[]{this.kubernetes.getMasterUrl().toString(), "api", "v1", "proxy", "namespaces", this.namespace, "services", service}));
            return new URL(URLUtils.join((String[])Lists.asList((Object)baseUrl.toString(), (Object[])parts).toArray(new String[0])));
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

