/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.k8s.helm;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.opennms.gizmo.k8s.GizmoK8sStacker;
import org.opennms.gizmo.k8s.utils.StackUtils;

public class HelmUtils {
    private static boolean isTillerRunning(GizmoK8sStacker stacker) {
        return StackUtils.getFirstRunningPod(stacker.getPodsWithLabels((Map<String, String>)ImmutableMap.of((Object)"app", (Object)"helm", (Object)"name", (Object)"tiller"))) != null;
    }

    public static void init(GizmoK8sStacker stacker) {
        if (HelmUtils.isTillerRunning(stacker)) {
            return;
        }
        CommandLine cmdLine = new CommandLine("helm");
        cmdLine.addArgument("init");
        cmdLine.addArgument("--upgrade");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)out, (OutputStream)err);
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog wd = new ExecuteWatchdog(-1L);
        executor.setWatchdog(wd);
        executor.setStreamHandler((ExecuteStreamHandler)psh);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        try {
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        try {
            resultHandler.waitFor();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        int exitCode = resultHandler.getExitValue();
        if (exitCode != 0) {
            throw new RuntimeException(String.format("Helm initialization failed with exit code %d. Stdout: %s Stderr: %s", exitCode, out, err));
        }
        for (int attempts = 0; !HelmUtils.isTillerRunning(stacker) && attempts < 5; ++attempts) {
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public static void install(String namespace, String chart) {
        CommandLine cmdLine = new CommandLine("helm");
        cmdLine.addArgument("install");
        cmdLine.addArgument("--namespace=${namespace}");
        cmdLine.addArgument("--name=${namespace}");
        cmdLine.addArgument("${chart}");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        map.put("chart", chart);
        cmdLine.setSubstitutionMap(map);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)out, (OutputStream)err);
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog wd = new ExecuteWatchdog(-1L);
        executor.setWatchdog(wd);
        executor.setStreamHandler((ExecuteStreamHandler)psh);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        try {
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        try {
            resultHandler.waitFor();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        int exitCode = resultHandler.getExitValue();
        if (exitCode != 0) {
            throw new RuntimeException(String.format("Chart installation failed with exit code %d. Stdout: %s Stderr: %s", exitCode, out, err));
        }
    }
}

