/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.k8s.portforward;

import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.opennms.gizmo.k8s.portforward.ForwardedPort;
import org.opennms.gizmo.k8s.portforward.PortForwardingStrategy;

public class KubeCtlPortForwardingStrategy
implements PortForwardingStrategy {
    protected static Integer getLocalPortFromOutput(String out) {
        Pattern p = Pattern.compile(" (.*):(\\d+) -> (\\d+)", 8);
        Matcher m = p.matcher(out);
        if (m.find()) {
            return Integer.valueOf(m.group(2));
        }
        return null;
    }

    protected static int waitForLocalPort(ExecuteWatchdog wd, ByteArrayOutputStream out, ByteArrayOutputStream err) {
        while (wd.isWatching()) {
            Integer port = KubeCtlPortForwardingStrategy.getLocalPortFromOutput(out.toString());
            if (port != null) {
                return port;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(String.format("Process execution failed. Stdout: %s Stderr: %s", out, err));
    }

    @Override
    public ForwardedPort portForward(String namespace, String pod, int remotePort) {
        CommandLine cmdLine = new CommandLine("kubectl");
        cmdLine.addArgument("--namespace=${namespace}");
        cmdLine.addArgument("port-forward");
        cmdLine.addArgument("${pod}");
        cmdLine.addArgument(":${remotePort}");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        map.put("pod", pod);
        map.put("remotePort", Integer.toString(remotePort));
        cmdLine.setSubstitutionMap(map);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)out, (OutputStream)err);
        DefaultExecutor executor = new DefaultExecutor();
        final ExecuteWatchdog wd = new ExecuteWatchdog(-1L);
        executor.setWatchdog(wd);
        executor.setStreamHandler((ExecuteStreamHandler)psh);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        try {
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        final int localPort = KubeCtlPortForwardingStrategy.waitForLocalPort(wd, out, err);
        return new ForwardedPort(){

            @Override
            public InetSocketAddress getAddress() {
                return new InetSocketAddress(InetAddress.getLoopbackAddress(), localPort);
            }

            @Override
            public void close() throws IOException {
                wd.destroyProcess();
            }

            public String toString() {
                return String.format("ForwardedPort[localPort=%d]", localPort);
            }
        };
    }
}

