/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.k8s.stacks;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.opennms.gizmo.k8s.GizmoK8sStack;
import org.opennms.gizmo.k8s.GizmoK8sStacker;
import org.opennms.gizmo.k8s.stacks.EmptyK8sStack;
import org.opennms.gizmo.k8s.stacks.YamlBasedK8sStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentBasedK8sStack
extends EmptyK8sStack {
    private static final Logger LOG = LoggerFactory.getLogger(YamlBasedK8sStack.class);

    @Override
    public void create(GizmoK8sStacker stacker, KubernetesClient kubernetes) {
        for (Secret secret : this.getSecrets(stacker)) {
            LOG.info("Creating secret: {}", (Object)secret);
            ((NonNamespaceOperation)kubernetes.secrets().inNamespace(stacker.getNamespace())).create((Object[])new Secret[]{secret});
        }
        for (Service svc : this.getServices(stacker)) {
            LOG.info("Creating service: {}", (Object)svc);
            ((NonNamespaceOperation)kubernetes.services().inNamespace(stacker.getNamespace())).create((Object[])new Service[]{svc});
        }
        for (ReplicationController rc : this.getReplicationControllers(stacker)) {
            LOG.info("Creating replication controller: {}", (Object)rc);
            ((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(stacker.getNamespace())).create((Object[])new ReplicationController[]{rc});
        }
        for (Pod pod : this.getPods(stacker)) {
            LOG.info("Creating pod: {}", (Object)pod);
            ((NonNamespaceOperation)kubernetes.pods().inNamespace(stacker.getNamespace())).create((Object[])new Pod[]{pod});
        }
    }

    public List<Secret> getSecrets(GizmoK8sStacker stacker) {
        return Collections.emptyList();
    }

    public List<Service> getServices(GizmoK8sStacker stacker) {
        return Collections.emptyList();
    }

    public List<ReplicationController> getReplicationControllers(GizmoK8sStacker stacker) {
        return Collections.emptyList();
    }

    public List<Pod> getPods(GizmoK8sStacker stacker) {
        return Collections.emptyList();
    }

    @Override
    public List<GizmoK8sStack> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public List<Consumer<GizmoK8sStacker>> getWaitingRules() {
        return Collections.emptyList();
    }
}

