/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.k8s.stacks;

import com.google.common.base.Throwables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.hubspot.jinjava.Jinjava;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScallableResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opennms.gizmo.k8s.GizmoK8sStack;
import org.opennms.gizmo.k8s.GizmoK8sStacker;
import org.opennms.gizmo.k8s.stacks.ComponentBasedK8sStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlBasedK8sStack
extends ComponentBasedK8sStack {
    private static final Logger LOG = LoggerFactory.getLogger(YamlBasedK8sStack.class);
    private final Multimap<String, String> documentsByKind = LinkedListMultimap.create();
    private final Jinjava jinjava = new Jinjava();
    private boolean useTemplating;

    public YamlBasedK8sStack(URL ... yaml) {
        Yaml yamlHandler = new Yaml();
        try {
            for (URL url : yaml) {
                for (Object doc : yamlHandler.loadAll(url.openStream())) {
                    this.documentsByKind.put((Object)YamlBasedK8sStack.getKind(doc).toLowerCase(), (Object)yamlHandler.dump(doc));
                }
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void useTemplating(boolean useTemplating) {
        this.useTemplating = useTemplating;
    }

    public Map<String, Object> getTemplateContext() {
        return Collections.emptyMap();
    }

    @Override
    public List<GizmoK8sStack> getDependencies() {
        return Collections.emptyList();
    }

    private InputStream maybeApplyTemplating(GizmoK8sStacker stacker, String doc) {
        String renderedDoc;
        if (!this.useTemplating) {
            renderedDoc = doc;
        } else {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("namespace", stacker.getNamespace());
            context.putAll(this.getTemplateContext());
            renderedDoc = this.jinjava.render(doc, context);
            LOG.debug("Rendered document: {}", (Object)renderedDoc);
        }
        return new ByteArrayInputStream(renderedDoc.getBytes());
    }

    @Override
    public List<Secret> getSecrets(GizmoK8sStacker stacker) {
        KubernetesClient client = stacker.getClient();
        return this.documentsByKind.get((Object)"secret").stream().map(doc -> (Secret)((Resource)client.secrets().load(this.maybeApplyTemplating(stacker, (String)doc))).get()).collect(Collectors.toList());
    }

    @Override
    public List<Service> getServices(GizmoK8sStacker stacker) {
        KubernetesClient client = stacker.getClient();
        return this.documentsByKind.get((Object)"service").stream().map(doc -> (Service)((Resource)client.services().load(this.maybeApplyTemplating(stacker, (String)doc))).get()).collect(Collectors.toList());
    }

    @Override
    public List<ReplicationController> getReplicationControllers(GizmoK8sStacker stacker) {
        KubernetesClient client = stacker.getClient();
        return this.documentsByKind.get((Object)"replicationcontroller").stream().map(doc -> (ReplicationController)((RollableScallableResource)client.replicationControllers().load(this.maybeApplyTemplating(stacker, (String)doc))).get()).collect(Collectors.toList());
    }

    @Override
    public List<Pod> getPods(GizmoK8sStacker stacker) {
        KubernetesClient client = stacker.getClient();
        return this.documentsByKind.get((Object)"pod").stream().map(doc -> (Pod)((PodResource)client.pods().load(this.maybeApplyTemplating(stacker, (String)doc))).get()).collect(Collectors.toList());
    }

    private static String getKind(Object document) {
        Map documentAsMap;
        Object type;
        if (document instanceof Map && (type = (documentAsMap = (Map)document).get("kind")) instanceof String) {
            return (String)type;
        }
        throw new RuntimeException("Unable to determine kind in " + document);
    }

    @Override
    public List<Consumer<GizmoK8sStacker>> getWaitingRules() {
        return Collections.emptyList();
    }
}

