/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.k8s.utils;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.List;
import org.opennms.gizmo.k8s.GizmoK8sStacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StackUtils.class);

    public static Pod getFirstRunningPod(GizmoK8sStacker stacker, String labelKey, String labelValue) {
        LOG.info("Retrieving pods using selector {}={}", (Object)labelKey, (Object)labelValue);
        List<Pod> pods = stacker.getPodsWithLabel(labelKey, labelValue);
        LOG.info("Found {} pods.", (Object)pods.size());
        return StackUtils.getFirstRunningPod(pods);
    }

    public static Pod getFirstRunningPod(List<Pod> pods) {
        if (pods.size() > 0) {
            for (Pod pod : pods) {
                if (!KubernetesHelper.isPodRunning((Pod)pod)) continue;
                LOG.info("{} is running.", (Object)pod.getMetadata().getName());
                return pod;
            }
            LOG.info("None of the pods are running.");
        }
        return null;
    }
}

