/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);

    public static URL toHttpUrl(InetSocketAddress addr) {
        try {
            return new URL(String.format("http://%s:%d/", addr.getHostString(), addr.getPort()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String get(InetSocketAddress httpAddr, String path) throws IOException {
        return HttpUtils.get(httpAddr, null, null, path);
    }

    public static String get(InetSocketAddress httpAddr, String username, String password, String path) throws IOException {
        try {
            OkHttpClient client = new OkHttpClient();
            Request.Builder builder = new Request.Builder();
            if (username != null && password != null) {
                builder.header("Authorization", Credentials.basic((String)username, (String)password));
            }
            Request request = builder.url(String.format("http://%s:%d%s", httpAddr.getHostString(), httpAddr.getPort(), path)).build();
            LOG.info("Calling URL: {}", (Object)request.url());
            Response response = client.newCall(request).execute();
            return response.isSuccessful() ? response.body().string() : null;
        }
        catch (IOException e) {
            LOG.info("Calling URL failed: {}", (Object)e.getMessage());
            return null;
        }
    }
}

