/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.gizmo.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Callable;

public class NetUtils {
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 100;

    public static boolean isTcpPortOpen(int port) {
        return NetUtils.isTcpPortOpen(new InetSocketAddress(InetAddress.getLoopbackAddress(), port), 100);
    }

    public static boolean isTcpPortOpen(int port, int connectTimeoutMs) {
        return NetUtils.isTcpPortOpen(new InetSocketAddress(InetAddress.getLoopbackAddress(), port), connectTimeoutMs);
    }

    public static boolean isTcpPortOpen(InetSocketAddress addr) {
        return NetUtils.isTcpPortOpen(addr, 100);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isTcpPortOpen(InetSocketAddress addr, int connectTimeoutMs) {
        try (Socket socket = new Socket();){
            socket.connect(addr, connectTimeoutMs);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Callable<Boolean> isTcpPortOpenCallable(int port) {
        return NetUtils.isTcpPortOpenCallable(port, 100);
    }

    public static Callable<Boolean> isTcpPortOpenCallable(final int port, final int connectTimeoutMs) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return NetUtils.isTcpPortOpen(port, connectTimeoutMs);
            }
        };
    }
}

