/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.datacollection.graphs.immutables;

import java.util.Arrays;
import java.util.Objects;
import org.opennms.integration.api.v1.config.datacollection.graphs.PrefabGraph;

public final class ImmutablePrefabGraph
implements PrefabGraph {
    private final String name;
    private final String title;
    private final String[] columns;
    private final String command;
    private final String[] externalValues;
    private final String[] propertiesValues;
    private final String[] types;
    private final String description;
    private final Integer graphWidth;
    private final Integer graphHeight;
    private final String[] supress;

    private ImmutablePrefabGraph(Builder builder) {
        this.name = builder.name;
        this.title = builder.title;
        this.columns = builder.columns == null ? null : (String[])builder.columns.clone();
        this.command = builder.command;
        this.externalValues = builder.externalValues == null ? null : (String[])builder.externalValues.clone();
        this.propertiesValues = builder.propertiesValues == null ? null : (String[])builder.propertiesValues.clone();
        this.types = builder.types == null ? null : (String[])builder.types.clone();
        this.description = builder.description;
        this.graphWidth = builder.graphWidth;
        this.graphHeight = builder.graphHeight;
        this.supress = builder.supress == null ? null : (String[])builder.supress.clone();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(PrefabGraph prefabGraph) {
        return new Builder(prefabGraph);
    }

    public static PrefabGraph immutableCopy(PrefabGraph prefabGraph) {
        if (prefabGraph == null || prefabGraph instanceof ImmutablePrefabGraph) {
            return prefabGraph;
        }
        return ImmutablePrefabGraph.newBuilderFrom(prefabGraph).build();
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getColumns() {
        return this.columns == null ? null : (String[])this.columns.clone();
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getExternalValues() {
        return this.externalValues == null ? null : (String[])this.externalValues.clone();
    }

    public String[] getPropertiesValues() {
        return this.propertiesValues == null ? null : (String[])this.propertiesValues.clone();
    }

    public String[] getTypes() {
        return this.types == null ? null : (String[])this.types.clone();
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getGraphWidth() {
        return this.graphWidth;
    }

    public Integer getGraphHeight() {
        return this.graphHeight;
    }

    public String[] getSupress() {
        return this.supress == null ? null : (String[])this.supress.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePrefabGraph that = (ImmutablePrefabGraph)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.title, that.title) && Arrays.equals(this.columns, that.columns) && Objects.equals(this.command, that.command) && Arrays.equals(this.externalValues, that.externalValues) && Arrays.equals(this.propertiesValues, that.propertiesValues) && Arrays.equals(this.types, that.types) && Objects.equals(this.description, that.description) && Objects.equals(this.graphWidth, that.graphWidth) && Objects.equals(this.graphHeight, that.graphHeight) && Arrays.equals(this.supress, that.supress);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.title, this.command, this.description, this.graphWidth, this.graphHeight);
        result = 31 * result + Arrays.hashCode(this.columns);
        result = 31 * result + Arrays.hashCode(this.externalValues);
        result = 31 * result + Arrays.hashCode(this.propertiesValues);
        result = 31 * result + Arrays.hashCode(this.types);
        result = 31 * result + Arrays.hashCode(this.supress);
        return result;
    }

    public String toString() {
        return "ImmutablePrefabGraph{name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", columns=" + Arrays.toString(this.columns) + ", command='" + this.command + '\'' + ", externalValues=" + Arrays.toString(this.externalValues) + ", propertiesValues=" + Arrays.toString(this.propertiesValues) + ", types=" + Arrays.toString(this.types) + ", description='" + this.description + '\'' + ", graphWidth=" + this.graphWidth + ", graphHeight=" + this.graphHeight + ", supress=" + Arrays.toString(this.supress) + '}';
    }

    public static final class Builder {
        private String name;
        private String title;
        private String[] columns;
        private String command;
        private String[] externalValues;
        private String[] propertiesValues;
        private String[] types;
        private String description;
        private Integer graphWidth;
        private Integer graphHeight;
        private String[] supress;

        private Builder() {
        }

        private Builder(PrefabGraph prefabGraph) {
            this.name = prefabGraph.getName();
            this.title = prefabGraph.getTitle();
            this.columns = prefabGraph.getColumns();
            this.command = prefabGraph.getCommand();
            this.externalValues = prefabGraph.getExternalValues();
            this.propertiesValues = prefabGraph.getPropertiesValues();
            this.types = prefabGraph.getTypes();
            this.description = prefabGraph.getDescription();
            this.graphWidth = prefabGraph.getGraphWidth();
            this.graphHeight = prefabGraph.getGraphHeight();
            this.supress = prefabGraph.getSupress();
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setColumns(String[] columns) {
            this.columns = columns;
            return this;
        }

        public Builder setCommand(String command) {
            this.command = command;
            return this;
        }

        public Builder setExternalValues(String[] externalValues) {
            this.externalValues = externalValues;
            return this;
        }

        public Builder setPropertiesValues(String[] propertiesValues) {
            this.propertiesValues = propertiesValues;
            return this;
        }

        public Builder setTypes(String[] types) {
            this.types = types;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setGraphWidth(Integer graphWidth) {
            this.graphWidth = graphWidth;
            return this;
        }

        public Builder setGraphHeight(Integer graphHeight) {
            this.graphHeight = graphHeight;
            return this;
        }

        public Builder setSupress(String[] supress) {
            this.supress = supress;
            return this;
        }

        public ImmutablePrefabGraph build() {
            return new ImmutablePrefabGraph(this);
        }
    }
}

