/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.topology.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.topology.UserDefinedLink;

public final class ImmutableUserDefinedLink
implements UserDefinedLink {
    private final int nodeIdA;
    private final String componentLabelA;
    private final int nodeIdZ;
    private final String componentLabelZ;
    private final String linkId;
    private final String linkLabel;
    private final String owner;
    private final Integer dbId;

    private ImmutableUserDefinedLink(Builder builder) {
        this.nodeIdA = builder.nodeIdA;
        this.componentLabelA = builder.componentLabelA;
        this.nodeIdZ = builder.nodeIdZ;
        this.componentLabelZ = builder.componentLabelZ;
        this.linkId = builder.linkId;
        this.linkLabel = builder.linkLabel;
        this.owner = builder.owner;
        this.dbId = builder.dbId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(UserDefinedLink userDefinedLink) {
        return new Builder(userDefinedLink);
    }

    public static UserDefinedLink immutableCopy(UserDefinedLink userDefinedLink) {
        if (userDefinedLink == null || userDefinedLink instanceof ImmutableUserDefinedLink) {
            return userDefinedLink;
        }
        return ImmutableUserDefinedLink.newBuilderFrom(userDefinedLink).build();
    }

    public int getNodeIdA() {
        return this.nodeIdA;
    }

    public String getComponentLabelA() {
        return this.componentLabelA;
    }

    public int getNodeIdZ() {
        return this.nodeIdZ;
    }

    public String getComponentLabelZ() {
        return this.componentLabelZ;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getLinkLabel() {
        return this.linkLabel;
    }

    public String getOwner() {
        return this.owner;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableUserDefinedLink that = (ImmutableUserDefinedLink)o;
        return this.nodeIdA == that.nodeIdA && this.nodeIdZ == that.nodeIdZ && Objects.equals(this.componentLabelA, that.componentLabelA) && Objects.equals(this.componentLabelZ, that.componentLabelZ) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.linkLabel, that.linkLabel) && Objects.equals(this.owner, that.owner) && Objects.equals(this.dbId, that.dbId);
    }

    public int hashCode() {
        return Objects.hash(this.nodeIdA, this.componentLabelA, this.nodeIdZ, this.componentLabelZ, this.linkLabel);
    }

    public String toString() {
        return "ImmutableUserDefinedLink{nodeIdA=" + this.nodeIdA + ", componentLabelA='" + this.componentLabelA + '\'' + ", nodeIdZ=" + this.nodeIdZ + ", componentLabelZ='" + this.componentLabelZ + '\'' + ", linkId='" + this.linkId + '\'' + ", linkLabel='" + this.linkLabel + '\'' + ", owner='" + this.owner + '\'' + ", dbId='" + this.dbId + '\'' + '}';
    }

    public static final class Builder {
        private Integer nodeIdA;
        private String componentLabelA;
        private Integer nodeIdZ;
        private String componentLabelZ;
        private String linkId;
        private String linkLabel;
        private String owner;
        private Integer dbId;

        private Builder() {
        }

        private Builder(UserDefinedLink userDefinedLink) {
            this.nodeIdA = userDefinedLink.getNodeIdA();
            this.componentLabelA = userDefinedLink.getComponentLabelA();
            this.nodeIdZ = userDefinedLink.getNodeIdZ();
            this.componentLabelZ = userDefinedLink.getComponentLabelZ();
            this.linkId = userDefinedLink.getLinkId();
            this.linkLabel = userDefinedLink.getLinkLabel();
            this.owner = userDefinedLink.getOwner();
            this.dbId = userDefinedLink.getDbId();
        }

        public Builder setNodeIdA(Integer nodeIdA) {
            this.nodeIdA = nodeIdA;
            return this;
        }

        public Builder setComponentLabelA(String componentLabelA) {
            this.componentLabelA = componentLabelA;
            return this;
        }

        public Builder setNodeIdZ(Integer nodeIdZ) {
            this.nodeIdZ = nodeIdZ;
            return this;
        }

        public Builder setComponentLabelZ(String componentLabelZ) {
            this.componentLabelZ = componentLabelZ;
            return this;
        }

        public Builder setLinkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public Builder setLinkLabel(String linkLabel) {
            this.linkLabel = linkLabel;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setDbId(Integer dbId) {
            this.dbId = dbId;
            return this;
        }

        public ImmutableUserDefinedLink build() {
            Objects.requireNonNull(this.nodeIdA, "nodeIdA is required");
            Objects.requireNonNull(this.nodeIdZ, "nodeIdZ is required");
            Objects.requireNonNull(this.linkId, "linkId is required");
            Objects.requireNonNull(this.owner, "owner is required");
            return new ImmutableUserDefinedLink(this);
        }
    }
}

