/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.immutables;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.Requisition;
import org.opennms.integration.api.v1.config.requisition.RequisitionNode;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionNode;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableRequisition
implements Requisition {
    private final String foreignSource;
    private final Date generatedAt;
    private final List<RequisitionNode> nodes;

    private ImmutableRequisition(Builder builder) {
        this.foreignSource = builder.foreignSource;
        this.generatedAt = builder.generatedAt != null ? builder.generatedAt : new Date();
        this.nodes = ImmutableCollections.with(ImmutableRequisitionNode::immutableCopy).newList(builder.nodes);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Requisition requisition) {
        return new Builder(requisition);
    }

    public static Requisition immutableCopy(Requisition requisition) {
        if (requisition == null || requisition instanceof ImmutableRequisition) {
            return requisition;
        }
        return ImmutableRequisition.newBuilderFrom(requisition).build();
    }

    public Date getGeneratedAt() {
        return this.generatedAt;
    }

    public List<RequisitionNode> getNodes() {
        return this.nodes;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRequisition that = (ImmutableRequisition)o;
        return Objects.equals(this.foreignSource, that.foreignSource) && Objects.equals(this.generatedAt, that.generatedAt) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.foreignSource, this.generatedAt, this.nodes);
    }

    public String toString() {
        return "ImmutableRequisition{foreignSource='" + this.foreignSource + '\'' + ", generatedAt=" + this.generatedAt + ", nodes=" + this.nodes + '}';
    }

    public static final class Builder {
        private String foreignSource;
        private Date generatedAt;
        private List<RequisitionNode> nodes;

        private Builder() {
        }

        private Builder(Requisition requisition) {
            this.foreignSource = requisition.getForeignSource();
            this.generatedAt = requisition.getGeneratedAt();
            this.nodes = MutableCollections.copyListFromNullable(requisition.getNodes());
        }

        public Builder setForeignSource(String foreignSource) {
            this.foreignSource = foreignSource;
            return this;
        }

        public Builder setGeneratedAt(Date generatedAt) {
            this.generatedAt = generatedAt;
            return this;
        }

        public Builder setNodes(List<RequisitionNode> nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder addNode(RequisitionNode node) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<RequisitionNode>();
            }
            this.nodes.add(node);
            return this;
        }

        public ImmutableRequisition build() {
            Objects.requireNonNull(this.foreignSource, "foreignSource is required");
            return new ImmutableRequisition(this);
        }
    }
}

