/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.immutables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.collectors.RrdRepository;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableRrdRepository
implements RrdRepository {
    private final int step;
    private final int heartbeat;
    private final List<String> rras;

    private ImmutableRrdRepository(Builder builder) {
        this.step = builder.step;
        this.heartbeat = builder.heartbeat;
        this.rras = ImmutableCollections.newListOfImmutableType(builder.rras);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(RrdRepository rrdRepository) {
        return new Builder(rrdRepository);
    }

    public static RrdRepository immutableCopy(RrdRepository rrdRepository) {
        if (rrdRepository == null || rrdRepository instanceof ImmutableRrdRepository) {
            return rrdRepository;
        }
        return ImmutableRrdRepository.newBuilderFrom(rrdRepository).build();
    }

    public int getStep() {
        return this.step;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public List<String> getRRAs() {
        return this.rras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRrdRepository that = (ImmutableRrdRepository)o;
        return this.step == that.step && this.heartbeat == that.heartbeat && Objects.equals(this.rras, that.rras);
    }

    public int hashCode() {
        return Objects.hash(this.step, this.heartbeat, this.rras);
    }

    public String toString() {
        return "ImmutableRrdRepository{step=" + this.step + ", heartbeat=" + this.heartbeat + ", rras=" + this.rras + '}';
    }

    public static final class Builder {
        private Integer step;
        private Integer heartbeat;
        private List<String> rras;

        private Builder() {
        }

        private Builder(RrdRepository rrdRepository) {
            this.step = rrdRepository.getStep();
            this.heartbeat = rrdRepository.getHeartbeat();
            this.rras = MutableCollections.copyListFromNullable(rrdRepository.getRRAs());
        }

        public Builder setStep(int step) {
            if (step <= 0) {
                throw new IllegalArgumentException("step must be strictly positive ( >0 )");
            }
            this.step = step;
            return this;
        }

        public Builder setHeartbeat(int heartbeat) {
            if (heartbeat <= 0) {
                throw new IllegalArgumentException("heartbeat must be strictly positive ( >0 )");
            }
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder setRRAs(List<String> rras) {
            this.rras = Objects.requireNonNull(rras);
            return this;
        }

        public Builder addRRA(String rra) {
            if (this.rras == null) {
                this.rras = new ArrayList<String>();
            }
            this.rras.add(rra);
            return this;
        }

        public ImmutableRrdRepository build() {
            Objects.requireNonNull(this.step, "step is required");
            Objects.requireNonNull(this.heartbeat, "heartbeat is required");
            if (this.rras.isEmpty()) {
                throw new IllegalArgumentException("One or more RRAs are required.");
            }
            return new ImmutableRrdRepository(this);
        }
    }
}

