/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.immutables;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionInterface;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.RequisitionMonitoredService;
import org.opennms.integration.api.v1.config.requisition.SnmpPrimaryType;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionMonitoredService;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableRequisitionInterface
implements RequisitionInterface {
    private final InetAddress ipAddress;
    private final SnmpPrimaryType snmpPrimary;
    private final String description;
    private final List<RequisitionMonitoredService> monitoredServices;
    private final List<RequisitionMetaData> metaData;

    private ImmutableRequisitionInterface(Builder builder) {
        this.ipAddress = builder.ipAddress;
        this.snmpPrimary = builder.snmpPrimary;
        this.description = builder.description;
        this.monitoredServices = ImmutableCollections.with(ImmutableRequisitionMonitoredService::immutableCopy).newList(builder.monitoredServices);
        this.metaData = ImmutableCollections.with(ImmutableRequisitionMetaData::immutableCopy).newList(builder.metaData);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(RequisitionInterface requisitionInterface) {
        return new Builder(requisitionInterface);
    }

    public static RequisitionInterface immutableCopy(RequisitionInterface requisitionInterface) {
        if (requisitionInterface == null || requisitionInterface instanceof ImmutableRequisitionInterface) {
            return requisitionInterface;
        }
        return ImmutableRequisitionInterface.newBuilderFrom(requisitionInterface).build();
    }

    public List<RequisitionMonitoredService> getMonitoredServices() {
        return this.monitoredServices;
    }

    public String getDescription() {
        return this.description;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public SnmpPrimaryType getSnmpPrimary() {
        return this.snmpPrimary;
    }

    public List<RequisitionMetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRequisitionInterface that = (ImmutableRequisitionInterface)o;
        return Objects.equals(this.ipAddress, that.ipAddress) && this.snmpPrimary == that.snmpPrimary && Objects.equals(this.description, that.description) && Objects.equals(this.monitoredServices, that.monitoredServices) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.snmpPrimary, this.description, this.monitoredServices, this.metaData);
    }

    public String toString() {
        return "ImmutableRequisitionInterface{ipAddress=" + this.ipAddress + ", snmpPrimary=" + this.snmpPrimary + ", description='" + this.description + '\'' + ", monitoredServices=" + this.monitoredServices + ", metaData=" + this.metaData + '}';
    }

    public static final class Builder {
        private InetAddress ipAddress;
        private SnmpPrimaryType snmpPrimary;
        private String description;
        private List<RequisitionMonitoredService> monitoredServices;
        private List<RequisitionMetaData> metaData;

        private Builder() {
        }

        private Builder(RequisitionInterface requisitionInterface) {
            this.ipAddress = requisitionInterface.getIpAddress();
            this.snmpPrimary = requisitionInterface.getSnmpPrimary();
            this.description = requisitionInterface.getDescription();
            this.monitoredServices = MutableCollections.copyListFromNullable(requisitionInterface.getMonitoredServices());
            this.metaData = MutableCollections.copyListFromNullable(requisitionInterface.getMetaData());
        }

        public Builder setIpAddress(InetAddress ipAddress) {
            this.ipAddress = Objects.requireNonNull(ipAddress);
            return this;
        }

        public Builder setSnmpPrimary(SnmpPrimaryType snmpPrimary) {
            this.snmpPrimary = snmpPrimary;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setMonitoredServices(List<RequisitionMonitoredService> monitoredServices) {
            this.monitoredServices = monitoredServices;
            return this;
        }

        public Builder addMonitoredService(RequisitionMonitoredService monitoredService) {
            if (this.monitoredServices == null) {
                this.monitoredServices = new ArrayList<RequisitionMonitoredService>();
            }
            this.monitoredServices.add(monitoredService);
            return this;
        }

        public Builder addMonitoredService(String name) {
            if (this.monitoredServices == null) {
                this.monitoredServices = new ArrayList<RequisitionMonitoredService>();
            }
            this.monitoredServices.add(ImmutableRequisitionMonitoredService.newInstance(name, null));
            return this;
        }

        public Builder setMetaData(List<RequisitionMetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder addMetaData(RequisitionMetaData requisitionMetaData) {
            if (this.metaData == null) {
                this.metaData = new ArrayList<RequisitionMetaData>();
            }
            this.metaData.add(requisitionMetaData);
            return this;
        }

        public ImmutableRequisitionInterface build() {
            Objects.requireNonNull(this.ipAddress, "ipAddress is required");
            return new ImmutableRequisitionInterface(this);
        }
    }
}

