/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.integration.api.v1.config.events.AlarmType;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableAlarm
implements Alarm {
    private final String reductionKey;
    private final Integer id;
    private final Node node;
    private final String managedObjectInstance;
    private final String managedObjectType;
    private final AlarmType type;
    private final Severity severity;
    private final Map<String, String> attributes;
    private final List<Alarm> relatedAlarms;
    private final String logMessage;
    private final String description;
    private final Date lastEventTime;
    private final Date firstEventTime;
    private final DatabaseEvent lastEvent;
    private final boolean acknowledged;

    private ImmutableAlarm(Builder builder) {
        this.reductionKey = builder.reductionKey;
        this.id = builder.id;
        this.node = builder.node;
        this.managedObjectInstance = builder.managedObjectInstance;
        this.managedObjectType = builder.managedObjectType;
        this.type = builder.type;
        this.severity = builder.severity;
        this.attributes = ImmutableCollections.newMapOfImmutableTypes(builder.attributes, LinkedHashMap::new);
        this.relatedAlarms = ImmutableCollections.with(ImmutableAlarm::immutableCopy).newList(builder.relatedAlarms);
        this.logMessage = builder.logMessage;
        this.description = builder.description;
        this.lastEventTime = builder.lastEventTime;
        this.firstEventTime = builder.firstEventTime;
        this.lastEvent = builder.lastEvent;
        this.acknowledged = builder.acknowledged;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Alarm fromAlarm) {
        return new Builder(fromAlarm);
    }

    public static Alarm immutableCopy(Alarm alarm) {
        if (alarm == null || alarm instanceof ImmutableAlarm) {
            return alarm;
        }
        return ImmutableAlarm.newBuilderFrom(alarm).build();
    }

    public String getReductionKey() {
        return this.reductionKey;
    }

    public Integer getId() {
        return this.id;
    }

    public Node getNode() {
        return this.node;
    }

    public AlarmType getType() {
        return this.type;
    }

    public String getManagedObjectInstance() {
        return this.managedObjectInstance;
    }

    public String getManagedObjectType() {
        return this.managedObjectType;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean isSituation() {
        return !this.relatedAlarms.isEmpty();
    }

    public List<Alarm> getRelatedAlarms() {
        return this.relatedAlarms;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getLastEventTime() {
        return this.lastEventTime;
    }

    public Date getFirstEventTime() {
        return this.firstEventTime;
    }

    public DatabaseEvent getLastEvent() {
        return this.lastEvent;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableAlarm that = (ImmutableAlarm)o;
        return Objects.equals(this.reductionKey, that.reductionKey) && Objects.equals(this.id, that.id) && Objects.equals(this.node, that.node) && Objects.equals(this.managedObjectInstance, that.managedObjectInstance) && Objects.equals(this.managedObjectType, that.managedObjectType) && this.type == that.type && this.severity == that.severity && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.relatedAlarms, that.relatedAlarms) && Objects.equals(this.logMessage, that.logMessage) && Objects.equals(this.description, that.description) && Objects.equals(this.lastEventTime, that.lastEventTime) && Objects.equals(this.firstEventTime, that.firstEventTime) && Objects.equals(this.lastEvent, that.lastEvent) && Objects.equals(this.acknowledged, that.acknowledged);
    }

    public int hashCode() {
        return Objects.hash(this.reductionKey, this.id, this.node, this.managedObjectInstance, this.managedObjectType, this.type, this.severity, this.attributes, this.relatedAlarms, this.logMessage, this.description, this.lastEventTime, this.firstEventTime, this.lastEvent, this.acknowledged);
    }

    public String toString() {
        return "ImmutableAlarm{reductionKey='" + this.reductionKey + "', id=" + this.id + ", node=" + this.node + ", managedObjectInstance='" + this.managedObjectInstance + "', managedObjectType='" + this.managedObjectType + "', type=" + this.type + ", severity=" + this.severity + ", attributes=" + this.attributes + ", relatedAlarms=" + this.relatedAlarms + ", logMessage='" + this.logMessage + "', description='" + this.description + "', lastEventTime=" + this.lastEventTime + ", firstEventTime=" + this.firstEventTime + ", lastEvent=" + this.lastEvent + ", acknowledged=" + this.acknowledged + "}";
    }

    public static final class Builder {
        private String reductionKey;
        private Integer id;
        private Node node;
        private String managedObjectInstance;
        private String managedObjectType;
        private AlarmType type;
        private Severity severity;
        private Map<String, String> attributes;
        private List<Alarm> relatedAlarms;
        private String logMessage;
        private String description;
        private Date lastEventTime;
        private Date firstEventTime;
        private DatabaseEvent lastEvent;
        private boolean acknowledged;

        private Builder() {
        }

        private Builder(Alarm alarm) {
            this.reductionKey = alarm.getReductionKey();
            this.id = alarm.getId();
            this.node = alarm.getNode();
            this.managedObjectInstance = alarm.getManagedObjectInstance();
            this.managedObjectType = alarm.getManagedObjectType();
            this.type = alarm.getType();
            this.severity = alarm.getSeverity();
            this.attributes = MutableCollections.copyMapFromNullable(alarm.getAttributes(), LinkedHashMap::new);
            this.relatedAlarms = MutableCollections.copyListFromNullable(alarm.getRelatedAlarms(), LinkedList::new);
            this.logMessage = alarm.getLogMessage();
            this.description = alarm.getDescription();
            this.lastEventTime = alarm.getLastEventTime();
            this.firstEventTime = alarm.getFirstEventTime();
            this.lastEvent = alarm.getLastEvent();
            this.acknowledged = alarm.isAcknowledged();
        }

        public Builder setReductionKey(String reductionKey) {
            this.reductionKey = reductionKey;
            return this;
        }

        public Builder setId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder setNode(Node node) {
            this.node = node;
            return this;
        }

        public Builder setManagedObjectInstance(String managedObjectInstance) {
            this.managedObjectInstance = managedObjectInstance;
            return this;
        }

        public Builder setManagedObjectType(String managedObjectType) {
            this.managedObjectType = managedObjectType;
            return this;
        }

        public Builder setType(AlarmType type) {
            this.type = type;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder addAttribute(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder setRelatedAlarms(List<Alarm> relatedAlarms) {
            this.relatedAlarms = relatedAlarms;
            return this;
        }

        public Builder addRelatedAlarm(Alarm relatedAlarm) {
            if (this.relatedAlarms == null) {
                this.relatedAlarms = new LinkedList<Alarm>();
            }
            this.relatedAlarms.add(relatedAlarm);
            return this;
        }

        public Builder setLogMessage(String logMessage) {
            this.logMessage = logMessage;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setLastEventTime(Date lastEventTime) {
            this.lastEventTime = lastEventTime;
            return this;
        }

        public Builder setFirstEventTime(Date firstEventTime) {
            this.firstEventTime = firstEventTime;
            return this;
        }

        public Builder setLastEvent(DatabaseEvent lastEvent) {
            this.lastEvent = lastEvent;
            return this;
        }

        public Builder setAcknowledged(boolean acknowledged) {
            this.acknowledged = acknowledged;
            return this;
        }

        public ImmutableAlarm build() {
            return new ImmutableAlarm(this);
        }
    }
}

