/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.NodeCriteria;
import org.opennms.integration.api.v1.model.TopologyPort;
import org.opennms.integration.api.v1.model.immutables.ImmutableNodeCriteria;

public final class ImmutableTopologyPort
implements TopologyPort {
    private final String id;
    private final String tooltipText;
    private final Integer ifIndex;
    private final String ifName;
    private final String ifAddress;
    private final NodeCriteria nodeCriteria;

    private ImmutableTopologyPort(Builder builder) {
        this.id = builder.id;
        this.tooltipText = builder.tooltipText;
        this.ifIndex = builder.ifIndex;
        this.ifName = builder.ifName;
        this.ifAddress = builder.ifAddress;
        this.nodeCriteria = ImmutableNodeCriteria.immutableCopy(builder.nodeCriteria);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(TopologyPort topologyPort) {
        return new Builder(topologyPort);
    }

    public static TopologyPort immutableCopy(TopologyPort topologyPort) {
        if (topologyPort == null || topologyPort instanceof ImmutableTopologyPort) {
            return topologyPort;
        }
        return ImmutableTopologyPort.newBuilderFrom(topologyPort).build();
    }

    public String getId() {
        return this.id;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public Integer getIfIndex() {
        return this.ifIndex;
    }

    public String getIfName() {
        return this.ifName;
    }

    public String getIfAddress() {
        return this.ifAddress;
    }

    public NodeCriteria getNodeCriteria() {
        return this.nodeCriteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTopologyPort that = (ImmutableTopologyPort)o;
        return Objects.equals(this.ifIndex, that.ifIndex) && Objects.equals(this.id, that.id) && Objects.equals(this.tooltipText, that.tooltipText) && Objects.equals(this.ifName, that.ifName) && Objects.equals(this.ifAddress, that.ifAddress) && Objects.equals(this.nodeCriteria, that.nodeCriteria);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tooltipText, this.ifIndex, this.ifName, this.ifAddress, this.nodeCriteria);
    }

    public String toString() {
        return "ImmutableTopologyPort{id='" + this.id + "', tooltipText='" + this.tooltipText + "', ifIndex=" + this.ifIndex + ", ifName='" + this.ifName + "', ifAddress='" + this.ifAddress + "', nodeCriteria=" + this.nodeCriteria + "}";
    }

    public static final class Builder {
        private String id;
        private String tooltipText;
        private Integer ifIndex;
        private String ifName;
        private String ifAddress;
        private NodeCriteria nodeCriteria;

        private Builder() {
        }

        private Builder(TopologyPort topologyPort) {
            this.id = topologyPort.getId();
            this.tooltipText = topologyPort.getTooltipText();
            this.ifIndex = topologyPort.getIfIndex();
            this.ifName = topologyPort.getIfName();
            this.ifAddress = topologyPort.getIfAddress();
            this.nodeCriteria = topologyPort.getNodeCriteria();
        }

        public Builder setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder setTooltipText(String tooltipText) {
            this.tooltipText = tooltipText;
            return this;
        }

        public Builder setIfIndex(Integer ifIndex) {
            this.ifIndex = ifIndex;
            return this;
        }

        public Builder setIfName(String ifName) {
            this.ifName = ifName;
            return this;
        }

        public Builder setIfAddress(String ifAddress) {
            this.ifAddress = ifAddress;
            return this;
        }

        public Builder setNodeCriteria(NodeCriteria nodeCriteria) {
            this.nodeCriteria = nodeCriteria;
            return this;
        }

        public ImmutableTopologyPort build() {
            Objects.requireNonNull(this.id);
            return new ImmutableTopologyPort(this);
        }
    }
}

