/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.collectors.resource.IpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.Resource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableNodeResource;

public final class ImmutableIpInterfaceResource
implements IpInterfaceResource {
    private final NodeResource nodeResource;
    private final String instance;

    private ImmutableIpInterfaceResource(NodeResource nodeResource, String instance) {
        this.nodeResource = ImmutableNodeResource.immutableCopy(nodeResource);
        this.instance = instance;
    }

    public static ImmutableIpInterfaceResource newInstance(NodeResource nodeResource, String instance) {
        return new ImmutableIpInterfaceResource(Objects.requireNonNull(nodeResource), Objects.requireNonNull(instance));
    }

    public static IpInterfaceResource immutableCopy(IpInterfaceResource ipInterfaceResource) {
        if (ipInterfaceResource == null || ipInterfaceResource instanceof ImmutableIpInterfaceResource) {
            return ipInterfaceResource;
        }
        return ImmutableIpInterfaceResource.newInstance(ipInterfaceResource.getNodeResource(), ipInterfaceResource.getInstance());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(IpInterfaceResource ipInterfaceResource) {
        return new Builder(ipInterfaceResource);
    }

    public NodeResource getNodeResource() {
        return this.nodeResource;
    }

    public String getInstance() {
        return this.instance;
    }

    public Resource.Type getResourceType() {
        return Resource.Type.INTERFACE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableIpInterfaceResource that = (ImmutableIpInterfaceResource)o;
        return Objects.equals(this.nodeResource, that.nodeResource) && Objects.equals(this.instance, that.instance);
    }

    public int hashCode() {
        return Objects.hash(this.nodeResource, this.instance);
    }

    public String toString() {
        return "ImmutableIpInterfaceResource{nodeResource=" + this.nodeResource + ", instance='" + this.instance + "'}";
    }

    public static final class Builder {
        private NodeResource nodeResource;
        private String instance;

        private Builder() {
        }

        private Builder(IpInterfaceResource ipInterfaceResource) {
            this.nodeResource = ipInterfaceResource.getNodeResource();
            this.instance = ipInterfaceResource.getInstance();
        }

        public Builder setNodeResource(NodeResource nodeResource) {
            this.nodeResource = Objects.requireNonNull(nodeResource);
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = Objects.requireNonNull(instance);
            return this;
        }

        public ImmutableIpInterfaceResource build() {
            return ImmutableIpInterfaceResource.newInstance(this.nodeResource, this.instance);
        }
    }
}

