/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.immutables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionAsset;
import org.opennms.integration.api.v1.config.requisition.RequisitionInterface;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.RequisitionNode;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionAsset;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionInterface;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionMetaData;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableRequisitionNode
implements RequisitionNode {
    private final String foreignId;
    private final String nodeLabel;
    private final String location;
    private final List<RequisitionInterface> interfaces;
    private final List<String> categories;
    private final List<RequisitionAsset> assets;
    private final List<RequisitionMetaData> metaData;

    private ImmutableRequisitionNode(Builder builder) {
        this.foreignId = builder.foreignId;
        this.nodeLabel = builder.nodeLabel;
        this.location = builder.location;
        this.interfaces = ImmutableCollections.with(ImmutableRequisitionInterface::immutableCopy).newList(builder.interfaces);
        this.categories = ImmutableCollections.newListOfImmutableType(builder.categories);
        this.assets = ImmutableCollections.with(ImmutableRequisitionAsset::immutableCopy).newList(builder.assets);
        this.metaData = ImmutableCollections.with(ImmutableRequisitionMetaData::immutableCopy).newList(builder.metaData);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(RequisitionNode requisitionNode) {
        return new Builder(requisitionNode);
    }

    public static RequisitionNode immutableCopy(RequisitionNode requisitionNode) {
        if (requisitionNode == null || requisitionNode instanceof ImmutableRequisitionNode) {
            return requisitionNode;
        }
        return ImmutableRequisitionNode.newBuilderFrom(requisitionNode).build();
    }

    public String getLocation() {
        return this.location;
    }

    public List<RequisitionInterface> getInterfaces() {
        return this.interfaces;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<RequisitionAsset> getAssets() {
        return this.assets;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public List<RequisitionMetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRequisitionNode that = (ImmutableRequisitionNode)o;
        return Objects.equals(this.foreignId, that.foreignId) && Objects.equals(this.nodeLabel, that.nodeLabel) && Objects.equals(this.location, that.location) && Objects.equals(this.interfaces, that.interfaces) && Objects.equals(this.categories, that.categories) && Objects.equals(this.assets, that.assets) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.foreignId, this.nodeLabel, this.location, this.interfaces, this.categories, this.assets, this.metaData);
    }

    public String toString() {
        return "ImmutableRequisitionNode{foreignId='" + this.foreignId + "', nodeLabel='" + this.nodeLabel + "', location='" + this.location + "', interfaces=" + this.interfaces + ", categories=" + this.categories + ", assets=" + this.assets + ", metaData=" + this.metaData + "}";
    }

    public static final class Builder {
        private String foreignId;
        private String nodeLabel;
        private String location;
        private List<RequisitionInterface> interfaces;
        private List<String> categories;
        private List<RequisitionAsset> assets;
        private List<RequisitionMetaData> metaData;

        private Builder() {
        }

        private Builder(RequisitionNode requisitionNode) {
            this.foreignId = requisitionNode.getForeignId();
            this.nodeLabel = requisitionNode.getNodeLabel();
            this.location = requisitionNode.getLocation();
            this.interfaces = MutableCollections.copyListFromNullable(requisitionNode.getInterfaces());
            this.categories = MutableCollections.copyListFromNullable(requisitionNode.getCategories());
            this.assets = MutableCollections.copyListFromNullable(requisitionNode.getAssets());
            this.metaData = MutableCollections.copyListFromNullable(requisitionNode.getMetaData());
        }

        public Builder setForeignId(String foreignId) {
            this.foreignId = foreignId;
            return this;
        }

        public Builder setNodeLabel(String nodeLabel) {
            this.nodeLabel = nodeLabel;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInterfaces(List<RequisitionInterface> interfaces) {
            this.interfaces = interfaces;
            return this;
        }

        public Builder addInterface(RequisitionInterface iface) {
            if (this.interfaces == null) {
                this.interfaces = new ArrayList<RequisitionInterface>();
            }
            this.interfaces.add(iface);
            return this;
        }

        public Builder setCategories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder addCategory(String category) {
            if (this.categories == null) {
                this.categories = new ArrayList<String>();
            }
            this.categories.add(category);
            return this;
        }

        public Builder setAssets(List<RequisitionAsset> assets) {
            this.assets = assets;
            return this;
        }

        public Builder addAsset(RequisitionAsset asset) {
            if (this.assets == null) {
                this.assets = new ArrayList<RequisitionAsset>();
            }
            this.assets.add(asset);
            return this;
        }

        public Builder addAsset(String name, String value) {
            if (this.assets == null) {
                this.assets = new ArrayList<RequisitionAsset>();
            }
            this.assets.add(ImmutableRequisitionAsset.newInstance(name, value));
            return this;
        }

        public Builder setMetaData(List<RequisitionMetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder addMetaData(RequisitionMetaData requisitionMetaData) {
            if (this.metaData == null) {
                this.metaData = new ArrayList<RequisitionMetaData>();
            }
            this.metaData.add(requisitionMetaData);
            return this;
        }

        public ImmutableRequisitionNode build() {
            Objects.requireNonNull(this.foreignId, "foreignId is required");
            return new ImmutableRequisitionNode(this);
        }
    }
}

