/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.Tag;

class MetricValidator
implements Serializable {
    private final Set<Tag> intrinsicTags;
    private final Set<Tag> metaTags;
    private final Set<Tag> externalTags;

    public MetricValidator(Set<Tag> intrinsicTags, Set<Tag> metaTags, Set<Tag> externalTags) {
        this.intrinsicTags = intrinsicTags;
        this.metaTags = metaTags;
        this.externalTags = externalTags;
    }

    public Set<Tag> getTagsByKey(String key) {
        return this.intrinsicTags.stream().filter(t -> Objects.equals(t.getKey(), key)).collect(Collectors.toSet());
    }

    public void validate() {
        this.requireNonNullTagSets();
        this.requireAtLeastOneIntrinsicTagToBePresent();
    }

    private void requireNonNullTagSets() {
        Objects.requireNonNull(this.intrinsicTags);
        Objects.requireNonNull(this.metaTags);
        Objects.requireNonNull(this.externalTags);
    }

    private void requireAtLeastOneIntrinsicTagToBePresent() {
        if (this.intrinsicTags.isEmpty()) {
            throw new IllegalArgumentException("At least one intrinsic tag is required");
        }
    }
}

