/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.model.NodeCriteria;

public final class ImmutableNodeCriteria
implements NodeCriteria {
    private final Integer id;
    private final String foreignSource;
    private final String foreignId;

    private ImmutableNodeCriteria(Builder builder) {
        this.id = builder.id;
        this.foreignSource = builder.foreignSource;
        this.foreignId = builder.foreignId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(NodeCriteria nodeCriteria) {
        return new Builder(nodeCriteria);
    }

    public static NodeCriteria immutableCopy(NodeCriteria nodeCriteria) {
        if (nodeCriteria == null || nodeCriteria instanceof ImmutableNodeCriteria) {
            return nodeCriteria;
        }
        return ImmutableNodeCriteria.newBuilderFrom(nodeCriteria).build();
    }

    public Integer getId() {
        return this.id;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String toRef() {
        if (this.foreignSource != null) {
            return this.foreignSource + ":" + this.foreignId;
        }
        return Integer.toString(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableNodeCriteria that = (ImmutableNodeCriteria)o;
        return this.id == that.id && Objects.equals(this.foreignSource, that.foreignSource) && Objects.equals(this.foreignId, that.foreignId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.foreignSource, this.foreignId);
    }

    public String toString() {
        return "ImmutableNodeCriteria{id=" + this.id + ", foreignSource='" + this.foreignSource + "', foreignId='" + this.foreignId + "'}";
    }

    public static final class Builder {
        private Integer id;
        private String foreignSource;
        private String foreignId;

        private Builder() {
        }

        private Builder(NodeCriteria nodeCriteria) {
            this.id = nodeCriteria.getId();
            this.foreignSource = nodeCriteria.getForeignSource();
            this.foreignId = nodeCriteria.getForeignId();
        }

        public Builder setId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder setForeignSource(String foreignSource) {
            this.foreignSource = foreignSource;
            return this;
        }

        public Builder setForeignId(String foreignId) {
            this.foreignId = foreignId;
            return this;
        }

        public ImmutableNodeCriteria build() {
            if (this.id == null && (this.foreignSource == null || this.foreignId == null)) {
                throw new IllegalStateException("Id is null but foreign source or foreign Id is not specified");
            }
            if (this.foreignSource != null && this.foreignId == null) {
                throw new NullPointerException("Foreign Id must be set when foreign source is set");
            }
            if (this.foreignId != null && this.foreignSource == null) {
                throw new NullPointerException("Foreign source must be set when foreign Id is set");
            }
            return new ImmutableNodeCriteria(this);
        }
    }
}

