/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;

public class ImmutableSample
implements Sample,
Serializable {
    private final Metric metric;
    private final Instant time;
    private final Double value;

    ImmutableSample(Metric metric, Instant time, Double value) {
        this.metric = Objects.requireNonNull(metric);
        this.time = Objects.requireNonNull(time);
        this.value = Objects.requireNonNull(value);
    }

    public Metric getMetric() {
        return this.metric;
    }

    public Instant getTime() {
        return this.time;
    }

    public Double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sample)) {
            return false;
        }
        Sample that = (Sample)o;
        return Objects.equals(this.metric, that.getMetric()) && Objects.equals(this.time, that.getTime()) && Objects.equals(this.value, that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.time, this.value);
    }

    public String toString() {
        return new StringJoiner(", ", ImmutableSample.class.getSimpleName() + "[", "]").add("metric=" + this.metric).add("time=" + this.time).add("value=" + this.value).toString();
    }

    public static ImmutableSampleBuilder builder() {
        return new ImmutableSampleBuilder();
    }

    public static class ImmutableSampleBuilder {
        private Metric metric;
        private Instant time;
        private Double value;

        ImmutableSampleBuilder() {
        }

        public ImmutableSampleBuilder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public ImmutableSampleBuilder time(Instant time) {
            this.time = time;
            return this;
        }

        public ImmutableSampleBuilder value(Double value) {
            this.value = value;
            return this;
        }

        public ImmutableSample build() {
            return new ImmutableSample(this.metric, this.time, this.value);
        }

        public String toString() {
            return "ImmutableSample.ImmutableSampleBuilder(metric=" + this.metric + ", time=" + this.time + ", value=" + this.value + ")";
        }
    }
}

