/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.config.thresholding.FilterOperator;
import org.opennms.integration.api.v1.config.thresholding.GroupDefinition;
import org.opennms.integration.api.v1.config.thresholding.ThresholdType;
import org.opennms.integration.api.xml.ClasspathXmlLoader;
import org.opennms.integration.api.xml.schema.thresholding.Basethresholddef;
import org.opennms.integration.api.xml.schema.thresholding.Expression;
import org.opennms.integration.api.xml.schema.thresholding.Group;
import org.opennms.integration.api.xml.schema.thresholding.ResourceFilter;
import org.opennms.integration.api.xml.schema.thresholding.Threshold;
import org.opennms.integration.api.xml.schema.thresholding.ThresholdingConfig;

public class ClasspathThresholdingConfigLoader
extends ClasspathXmlLoader<ThresholdingConfig> {
    public ClasspathThresholdingConfigLoader(Class<?> clazz, String ... fileNames) {
        super(clazz, ThresholdingConfig.class, "thresholding", fileNames);
    }

    public List<GroupDefinition> getGroupDefinitions() {
        return this.getObjects().stream().flatMap(tc -> tc.getGroups().stream()).map(ClasspathThresholdingConfigLoader::toGroupDefinition).collect(Collectors.toList());
    }

    private static GroupDefinition toGroupDefinition(final Group group) {
        return new GroupDefinition(){
            private final String name;
            private final String rrdRepository;
            private final List<org.opennms.integration.api.v1.config.thresholding.Threshold> thresholds;
            private final List<org.opennms.integration.api.v1.config.thresholding.Expression> expressions;
            {
                this.name = group.getName();
                this.rrdRepository = group.getRrdRepository();
                this.thresholds = Collections.unmodifiableList(group.getThresholds().stream().map(ThresholdImpl::new).collect(Collectors.toList()));
                this.expressions = Collections.unmodifiableList(group.getExpressions().stream().map(ExpressionImpl::new).collect(Collectors.toList()));
            }

            public String getName() {
                return this.name;
            }

            public String getRrdRepository() {
                return this.rrdRepository;
            }

            public List<org.opennms.integration.api.v1.config.thresholding.Threshold> getThresholds() {
                return this.thresholds;
            }

            public List<org.opennms.integration.api.v1.config.thresholding.Expression> getExpressions() {
                return this.expressions;
            }
        };
    }

    private static org.opennms.integration.api.v1.config.thresholding.ResourceFilter toResourceFilter(final ResourceFilter resourceFilter) {
        return new org.opennms.integration.api.v1.config.thresholding.ResourceFilter(){

            public Optional<String> getContent() {
                return resourceFilter.getContent();
            }

            public String getField() {
                return resourceFilter.getField();
            }
        };
    }

    private static class ExpressionImpl
    extends BasethresholddefImpl
    implements org.opennms.integration.api.v1.config.thresholding.Expression {
        private final String expression;

        ExpressionImpl(Expression expression) {
            super(Objects.requireNonNull(expression));
            this.expression = expression.getExpression();
        }

        public String getExpression() {
            return this.expression;
        }
    }

    private static class ThresholdImpl
    extends BasethresholddefImpl
    implements org.opennms.integration.api.v1.config.thresholding.Threshold {
        private final String dsName;

        ThresholdImpl(Threshold threshold) {
            super(Objects.requireNonNull(threshold));
            this.dsName = threshold.getDsName();
        }

        public String getDsName() {
            return this.dsName;
        }
    }

    private static class BasethresholddefImpl
    implements org.opennms.integration.api.v1.config.thresholding.Basethresholddef {
        private final Basethresholddef basethresholddef;
        private final List<org.opennms.integration.api.v1.config.thresholding.ResourceFilter> resourceFilters;

        BasethresholddefImpl(Basethresholddef basethresholddef) {
            this.basethresholddef = Objects.requireNonNull(basethresholddef);
            this.resourceFilters = Collections.unmodifiableList(basethresholddef.getResourceFilters().stream().map(x$0 -> ClasspathThresholdingConfigLoader.toResourceFilter(x$0)).collect(Collectors.toList()));
        }

        public Boolean getRelaxed() {
            return this.basethresholddef.getRelaxed();
        }

        public Optional<String> getDescription() {
            return this.basethresholddef.getDescription();
        }

        public ThresholdType getType() {
            return ThresholdType.forName((String)this.basethresholddef.getType().getEnumName());
        }

        public String getDsType() {
            return this.basethresholddef.getDsType();
        }

        public Double getValue() {
            return this.basethresholddef.getValue();
        }

        public Double getRearm() {
            return this.basethresholddef.getRearm();
        }

        public Integer getTrigger() {
            return this.basethresholddef.getTrigger();
        }

        public Optional<String> getDsLabel() {
            return this.basethresholddef.getDsLabel();
        }

        public Optional<String> getTriggeredUEI() {
            return this.basethresholddef.getTriggeredUEI();
        }

        public Optional<String> getRearmedUEI() {
            return this.basethresholddef.getRearmedUEI();
        }

        public FilterOperator getFilterOperator() {
            return FilterOperator.valueOf((String)this.basethresholddef.getFilterOperator().name());
        }

        public List<org.opennms.integration.api.v1.config.thresholding.ResourceFilter> getResourceFilters() {
            return this.resourceFilters;
        }
    }
}

