/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.config.datacollection.Collect;
import org.opennms.integration.api.v1.config.datacollection.ResourceType;
import org.opennms.integration.api.v1.config.datacollection.SnmpDataCollection;
import org.opennms.integration.api.xml.ClassPathResourceTypesLoader;
import org.opennms.integration.api.xml.ClasspathXmlLoader;
import org.opennms.integration.api.xml.schema.datacollection.DatacollectionGroup;
import org.opennms.integration.api.xml.schema.datacollection.Group;
import org.opennms.integration.api.xml.schema.datacollection.IpList;
import org.opennms.integration.api.xml.schema.datacollection.MibObj;
import org.opennms.integration.api.xml.schema.datacollection.MibObjProperty;
import org.opennms.integration.api.xml.schema.datacollection.Parameter;
import org.opennms.integration.api.xml.schema.datacollection.SystemDef;

public class ClasspathSnmpDataCollectionLoader
extends ClasspathXmlLoader<DatacollectionGroup> {
    public ClasspathSnmpDataCollectionLoader(Class<?> clazz, String ... fileNames) {
        super(clazz, DatacollectionGroup.class, "datacollection", fileNames);
    }

    public List<SnmpDataCollection> getSnmpDataCollections() {
        return this.getObjects().stream().map(ClasspathSnmpDataCollectionLoader::toSnmpDataCollection).collect(Collectors.toList());
    }

    public static SnmpDataCollection toSnmpDataCollection(final DatacollectionGroup datacollectionGroup) {
        final List resourceTypes = datacollectionGroup.getResourceTypes().stream().map(ClassPathResourceTypesLoader::toResourceType).collect(Collectors.toList());
        final List groups = datacollectionGroup.getGroups().stream().map(ClasspathSnmpDataCollectionLoader::toGroup).collect(Collectors.toList());
        final List systemDefs = datacollectionGroup.getSystemDefs().stream().map(ClasspathSnmpDataCollectionLoader::toSystemDef).collect(Collectors.toList());
        return new SnmpDataCollection(){

            public String getName() {
                return datacollectionGroup.getName();
            }

            public List<ResourceType> getResourceTypes() {
                return resourceTypes;
            }

            public List<org.opennms.integration.api.v1.config.datacollection.Group> getGroups() {
                return groups;
            }

            public List<org.opennms.integration.api.v1.config.datacollection.SystemDef> getSystemDefs() {
                return systemDefs;
            }
        };
    }

    public static org.opennms.integration.api.v1.config.datacollection.Group toGroup(final Group group) {
        final List mibObjs = group.getMibObjs().stream().map(ClasspathSnmpDataCollectionLoader::toMibObj).collect(Collectors.toList());
        final List properties = group.getProperties().stream().map(ClasspathSnmpDataCollectionLoader::toProperties).collect(Collectors.toList());
        return new org.opennms.integration.api.v1.config.datacollection.Group(){

            public String getName() {
                return group.getName();
            }

            public String getIfType() {
                return group.getIfType();
            }

            public List<org.opennms.integration.api.v1.config.datacollection.MibObj> getMibObjs() {
                return mibObjs;
            }

            public List<org.opennms.integration.api.v1.config.datacollection.MibObjProperty> getProperties() {
                return properties;
            }

            public List<String> getIncludeGroups() {
                return group.getIncludeGroups();
            }
        };
    }

    public static org.opennms.integration.api.v1.config.datacollection.MibObj toMibObj(final MibObj mibObj) {
        return new org.opennms.integration.api.v1.config.datacollection.MibObj(){

            public String getOid() {
                return mibObj.getOid();
            }

            public String getInstance() {
                return mibObj.getInstance();
            }

            public String getAlias() {
                return mibObj.getAlias();
            }

            public String getType() {
                return mibObj.getType();
            }

            public String getMaxval() {
                return mibObj.getMaxval();
            }

            public String getMinval() {
                return mibObj.getMinval();
            }
        };
    }

    public static org.opennms.integration.api.v1.config.datacollection.MibObjProperty toProperties(final MibObjProperty mibObjProperty) {
        final List parameters = mibObjProperty.getParameters().stream().map(ClasspathSnmpDataCollectionLoader::toParameter).collect(Collectors.toList());
        return new org.opennms.integration.api.v1.config.datacollection.MibObjProperty(){

            public String getInstance() {
                return mibObjProperty.getInstance();
            }

            public String getAlias() {
                return mibObjProperty.getAlias();
            }

            public String getClassName() {
                return mibObjProperty.getClassName();
            }

            public List<org.opennms.integration.api.v1.config.datacollection.Parameter> getParameters() {
                return parameters;
            }
        };
    }

    public static org.opennms.integration.api.v1.config.datacollection.Parameter toParameter(final Parameter parameter) {
        return new org.opennms.integration.api.v1.config.datacollection.Parameter(){

            public String getKey() {
                return parameter.getKey();
            }

            public String getValue() {
                return parameter.getValue();
            }
        };
    }

    public static org.opennms.integration.api.v1.config.datacollection.SystemDef toSystemDef(final SystemDef systemDef) {
        final org.opennms.integration.api.v1.config.datacollection.IpList ipList = ClasspathSnmpDataCollectionLoader.toIpList(systemDef.getIpList());
        final Collect collect = systemDef.getCollect() != null ? systemDef.getCollect()::getIncludeGroups : null;
        return new org.opennms.integration.api.v1.config.datacollection.SystemDef(){

            public String getName() {
                return systemDef.getName();
            }

            public String getSysoid() {
                return systemDef.getSysoid();
            }

            public String getSysoidMask() {
                return systemDef.getSysoidMask();
            }

            public org.opennms.integration.api.v1.config.datacollection.IpList getIpList() {
                return ipList;
            }

            public Collect getCollect() {
                return collect;
            }
        };
    }

    public static org.opennms.integration.api.v1.config.datacollection.IpList toIpList(final IpList ipList) {
        if (ipList == null) {
            return null;
        }
        return new org.opennms.integration.api.v1.config.datacollection.IpList(){

            public List<String> getIpAddresses() {
                return ipList.getIpAddresses();
            }

            public List<String> getIpAddressMasks() {
                return ipList.getIpAddressMasks();
            }
        };
    }
}

