# OpenNMS ${pluginName} Plugin

## Overview

This plugin was generated by the OIA archetype and is used as example project layout.

The generated plugin contains code examples to demonstrate how to create a:
* Karaf Shell Command (see StatsCommand & TopologyCommand)
* REST Endpoint (see WebhookHandler & WebhookHandlerImpl)
* Event Configuration Extension (see EventConfExtension)
* Alarm Lifecycle Listener (see AlarmForwarder)

## Developing

Build and install the plugin into your local Maven repository using:
```
mvn clean install
```

> OpenNMS normally runs as root, so make sure the artifacts are installed in `/root/.m2` or try making `/root/.m2` symlink to your user's repository

From the OpenNMS Karaf shell:
```
feature:repo-add mvn:${groupId}/karaf-features/1.0.0-SNAPSHOT/xml
feature:install opennms-plugins-${pluginId}
```

Update automatically:
```
bundle:watch *
```

## Features

Once installed, the plugin makes the following Karaf shell commands available:
* opennms-${pluginId}:stats
* opennms-${pluginId}:push-topology

You can also access the REST endpoint mounted by the plugin at `http://localhost:8980/opennms/rest/${pluginId}/ping`
