/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTag;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTimeSeriesFetchRequest;

public abstract class AbstractStorageIntegrationTest {
    protected List<Metric> metrics;
    protected List<Sample> samplesOfFirstMetric;
    protected TimeSeriesStorage storage;

    @Before
    public void setUp() throws StorageException {
        this.metrics = AbstractStorageIntegrationTest.createMetrics();
        List samples = this.metrics.stream().map(AbstractStorageIntegrationTest::createSamplesForMetric).flatMap(Collection::stream).collect(Collectors.toList());
        this.storage = this.createStorage();
        this.storage.store(samples);
        this.samplesOfFirstMetric = samples.stream().filter(s -> s.getMetric().equals(this.metrics.get(0))).collect(Collectors.toList());
        this.waitForPersistingChanges();
    }

    protected abstract TimeSeriesStorage createStorage();

    protected void waitForPersistingChanges() {
    }

    @Test
    public void shouldLoadMultipleMetricsWithSameTag() throws StorageException {
        List metricsRetrieved = this.storage.getMetrics(Arrays.asList(this.metrics.get(0).getFirstTagByKey("name"), new ImmutableTag("_idx1", "(snmp:1,4)")));
        Assert.assertEquals((long)this.metrics.size(), (long)metricsRetrieved.size());
        Assert.assertEquals(new HashSet<Metric>(this.metrics), new HashSet(metricsRetrieved));
    }

    @Test
    public void shouldLoadOneMetricsWithUniqueTag() throws StorageException {
        Metric metric = this.metrics.get(0);
        List metricsRetrieved = this.storage.getMetrics(Arrays.asList(metric.getFirstTagByKey("name"), metric.getFirstTagByKey("resourceId")));
        Assert.assertEquals((long)1L, (long)metricsRetrieved.size());
        Metric metricFromDb = (Metric)metricsRetrieved.get(0);
        Assert.assertEquals((Object)metric, (Object)metricFromDb);
        Assert.assertEquals((Object)metric.getMetaTags(), (Object)metricFromDb.getMetaTags());
    }

    @Test
    public void shouldLoadMetricsByWildcardTag() throws StorageException {
        List metricsRetrieved = this.storage.getMetrics(Arrays.asList(this.metrics.get(0).getFirstTagByKey("name"), new ImmutableTag("_idx2w", "(snmp:1,*)")));
        Assert.assertEquals((long)this.metrics.size(), (long)metricsRetrieved.size());
        Assert.assertEquals(new HashSet<Metric>(this.metrics), new HashSet(metricsRetrieved));
    }

    @Test
    public void shouldGetSamplesForMetric() throws StorageException {
        ImmutableMetric.MetricBuilder builder = ImmutableMetric.builder();
        this.metrics.get(0).getIntrinsicTags().forEach(arg_0 -> ((ImmutableMetric.MetricBuilder)builder).intrinsicTag(arg_0));
        ImmutableMetric metric = builder.build();
        List<Sample> samples = this.loadSamplesForMetric((Metric)metric);
        Assert.assertEquals(this.samplesOfFirstMetric, samples);
        for (int i = 0; i < this.samplesOfFirstMetric.size(); ++i) {
            Assert.assertEquals((Object)this.samplesOfFirstMetric.get(i).getMetric().getMetaTags(), (Object)samples.get(i).getMetric().getMetaTags());
        }
    }

    @Test
    public void shouldDeleteMetrics() throws StorageException {
        Metric lastMetric = this.metrics.get(this.metrics.size() - 1);
        List metricsRetrieved = this.storage.getMetrics(Collections.singletonList(this.metrics.get(0).getFirstTagByKey("name")));
        Assert.assertEquals(new HashSet<Metric>(this.metrics), new HashSet(metricsRetrieved));
        List<Sample> samples = this.loadSamplesForMetric(lastMetric);
        Assert.assertEquals((long)this.samplesOfFirstMetric.size(), (long)samples.size());
        this.storage.delete(lastMetric);
        metricsRetrieved = this.storage.getMetrics((Collection)lastMetric.getIntrinsicTags());
        Assert.assertTrue((boolean)metricsRetrieved.isEmpty());
        samples = this.loadSamplesForMetric(lastMetric);
        Assert.assertEquals((long)0L, (long)samples.size());
        metricsRetrieved = this.storage.getMetrics(Collections.singletonList(this.metrics.get(0).getFirstTagByKey("name")));
        Assert.assertEquals(new HashSet<Metric>(this.metrics.subList(0, this.metrics.size() - 1)), new HashSet(metricsRetrieved));
        samples = this.loadSamplesForMetric(this.metrics.get(0));
        Assert.assertEquals(this.samplesOfFirstMetric, samples);
    }

    private List<Sample> loadSamplesForMetric(Metric metric) throws StorageException {
        ImmutableTimeSeriesFetchRequest request = ImmutableTimeSeriesFetchRequest.builder().start(Instant.now().minusSeconds(300L)).end(Instant.now()).metric(metric).aggregation(Aggregation.NONE).step(Duration.ZERO).build();
        return this.storage.getTimeseries((TimeSeriesFetchRequest)request);
    }

    private static List<Sample> createSamplesForMetric(Metric metric) {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (int i = 1; i <= 5; ++i) {
            samples.add(AbstractStorageIntegrationTest.createSampleForMetric(metric, i));
        }
        return samples;
    }

    private static Sample createSampleForMetric(Metric metric, int index) {
        return ImmutableSample.builder().time(Instant.now().with(ChronoField.MICRO_OF_SECOND, 0L).plus((long)index, ChronoUnit.MILLIS)).value(Double.valueOf(42.3)).metric(metric).build();
    }

    private static List<Metric> createMetrics() {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (int i = 1; i < 5; ++i) {
            metrics.add(AbstractStorageIntegrationTest.createMetric(uuid, i));
        }
        return metrics;
    }

    private static Metric createMetric(String uuid, int nodeId) {
        String mtype = nodeId % 2 == 0 ? Metric.Mtype.gauge.name() : Metric.Mtype.counter.name();
        return ImmutableMetric.builder().intrinsicTag("name", "n" + uuid).intrinsicTag("resourceId", String.format("snmp:%s:opennms-jvm:org_opennms_newts_name_ring_buffer_max_size_unit=unknown", nodeId)).metaTag("mtype", mtype).metaTag("_idx0", "(snmp,4)").metaTag("_idx1", "(snmp:1,4)").metaTag("_idx2w", "(snmp:1,*)").metaTag("_idx2", "(snmp:1:opennms-jvm,4)").metaTag("_idx3", "(snmp:1:opennms-jvm:OpenNMS_Name_Notifd,4)").metaTag("host", "myHost" + nodeId).build();
    }
}

