/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.TagMatcher;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTagMatcher;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTimeSeriesFetchRequest;

public abstract class AbstractStorageIntegrationTest {
    protected List<Metric> metrics;
    protected List<Sample> samplesOfFirstMetric;
    protected TimeSeriesStorage storage;
    protected Instant referenceTime;

    @Before
    public void setUp() throws Exception {
        this.referenceTime = Instant.now().with(ChronoField.MICRO_OF_SECOND, 0L);
        this.metrics = AbstractStorageIntegrationTest.createMetrics();
        List samples = this.metrics.stream().map(this::createSamplesForMetric).flatMap(Collection::stream).collect(Collectors.toList());
        this.storage = this.createStorage();
        this.storage.store(samples);
        this.samplesOfFirstMetric = samples.stream().filter(s -> s.getMetric().equals(this.metrics.get(0))).collect(Collectors.toList());
        this.waitForPersistingChanges();
    }

    protected abstract TimeSeriesStorage createStorage() throws Exception;

    protected void waitForPersistingChanges() throws Exception {
    }

    @Test
    public void shouldLoadMultipleMetricsWithSameTag() throws Exception {
        List metricsRetrieved = this.storage.findMetrics(Collections.singletonList(new ImmutableTagMatcher(TagMatcher.Type.EQUALS, "name", this.metrics.get(0).getFirstTagByKey("name").getValue())));
        Assert.assertEquals((long)this.metrics.size(), (long)metricsRetrieved.size());
        Assert.assertEquals(new HashSet<Metric>(this.metrics), new HashSet(metricsRetrieved));
    }

    @Test
    public void shouldFindOneMetricWithUniqueTag() throws Exception {
        Metric metric = this.metrics.get(0);
        TagMatcher nameMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.EQUALS).key("name").value(metric.getFirstTagByKey("name").getValue()).build();
        TagMatcher resourceIdMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.EQUALS).key("resourceId").value(metric.getFirstTagByKey("resourceId").getValue()).build();
        List metricsRetrieved = this.storage.findMetrics(Arrays.asList(nameMatcher, resourceIdMatcher));
        Assert.assertEquals((long)1L, (long)metricsRetrieved.size());
        Metric metricFromDb = (Metric)metricsRetrieved.get(0);
        Assert.assertEquals((Object)metric, (Object)metricFromDb);
        Assert.assertEquals((Object)metric.getMetaTags(), (Object)metricFromDb.getMetaTags());
    }

    @Test
    public void shouldFindOneMetricWithRegexMatching() throws Exception {
        Metric metric = this.metrics.get(0);
        String regex = metric.getFirstTagByKey("name").getValue().substring(0, 5) + ".*";
        TagMatcher nameMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.EQUALS_REGEX).key("name").value(regex).build();
        regex = metric.getFirstTagByKey("resourceId").getValue().substring(0, 10) + ".*";
        TagMatcher resourceIdMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.EQUALS_REGEX).key("resourceId").value(regex).build();
        List metricsRetrieved = this.storage.findMetrics(Arrays.asList(nameMatcher, resourceIdMatcher));
        Assert.assertEquals((long)1L, (long)metricsRetrieved.size());
        Metric metricFromDb = (Metric)metricsRetrieved.get(0);
        Assert.assertEquals((Object)metric, (Object)metricFromDb);
        Assert.assertEquals((Object)metric.getMetaTags(), (Object)metricFromDb.getMetaTags());
    }

    @Test
    public void shouldFindWithNotEquals() throws Exception {
        Metric metric = this.metrics.get(0);
        TagMatcher resourceIdMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.NOT_EQUALS).key("resourceId").value(metric.getFirstTagByKey("resourceId").getValue()).build();
        List metricsRetrieved = this.storage.findMetrics(Collections.singletonList(resourceIdMatcher));
        Assert.assertEquals((long)(this.metrics.size() - 1), (long)metricsRetrieved.size());
    }

    @Test
    public void shouldFindOneMetricWithRegexNotMatching() throws Exception {
        Metric metric = this.metrics.get(0);
        String regex = metric.getFirstTagByKey("resourceId").getValue().substring(0, 10) + ".*";
        TagMatcher resourceIdMatcher = ImmutableTagMatcher.builder().type(TagMatcher.Type.NOT_EQUALS_REGEX).key("resourceId").value(regex).build();
        List metricsRetrieved = this.storage.findMetrics(Collections.singletonList(resourceIdMatcher));
        Assert.assertEquals((long)(this.metrics.size() - 1), (long)metricsRetrieved.size());
    }

    @Test
    public void shouldThrowExceptionWhenFindCalledWithoutTagMatcher() throws Exception {
        Assert.assertThrows(NullPointerException.class, () -> this.storage.findMetrics(null));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.storage.findMetrics(new HashSet()));
    }

    @Test
    public void shouldGetSamplesForMetric() throws Exception {
        ImmutableMetric.MetricBuilder builder = ImmutableMetric.builder();
        this.metrics.get(0).getIntrinsicTags().forEach(arg_0 -> ((ImmutableMetric.MetricBuilder)builder).intrinsicTag(arg_0));
        ImmutableMetric metric = builder.build();
        List<Sample> samples = this.loadSamplesForMetric((Metric)metric);
        Assert.assertEquals(this.samplesOfFirstMetric, samples);
        for (int i = 0; i < this.samplesOfFirstMetric.size(); ++i) {
            Assert.assertEquals((Object)this.samplesOfFirstMetric.get(i).getMetric().getMetaTags(), (Object)samples.get(i).getMetric().getMetaTags());
        }
    }

    @Test
    public void shouldDeleteMetrics() throws Exception {
        Metric lastMetric = this.metrics.get(this.metrics.size() - 1);
        List<Tag> listOfCommonTags = Collections.singletonList(this.metrics.get(0).getFirstTagByKey("name"));
        List<Metric> metricsRetrieved = this.findMetricsByTags(listOfCommonTags);
        Assert.assertEquals(new HashSet<Metric>(this.metrics), new HashSet<Metric>(metricsRetrieved));
        List<Sample> samples = this.loadSamplesForMetric(lastMetric);
        Assert.assertEquals((long)this.samplesOfFirstMetric.size(), (long)samples.size());
        this.storage.delete(lastMetric);
        metricsRetrieved = this.findMetricsByTags(lastMetric.getIntrinsicTags());
        Assert.assertTrue((boolean)metricsRetrieved.isEmpty());
        samples = this.loadSamplesForMetric(lastMetric);
        Assert.assertEquals((long)0L, (long)samples.size());
        metricsRetrieved = this.findMetricsByTags(listOfCommonTags);
        Assert.assertEquals(new HashSet<Metric>(this.metrics.subList(0, this.metrics.size() - 1)), new HashSet<Metric>(metricsRetrieved));
        samples = this.loadSamplesForMetric(this.metrics.get(0));
        Assert.assertEquals(this.samplesOfFirstMetric, samples);
    }

    private List<Metric> findMetricsByTags(Collection<Tag> tags) throws StorageException {
        List matchers = tags.stream().map(t -> ImmutableTagMatcher.TagMatcherBuilder.of((Tag)t).build()).collect(Collectors.toList());
        return this.storage.findMetrics(matchers);
    }

    protected List<Sample> loadSamplesForMetric(Metric metric) throws Exception {
        ImmutableTimeSeriesFetchRequest request = ImmutableTimeSeriesFetchRequest.builder().start(this.referenceTime.minusSeconds(300L)).end(this.referenceTime).metric(metric).aggregation(Aggregation.NONE).step(Duration.ZERO).build();
        return this.storage.getTimeseries((TimeSeriesFetchRequest)request);
    }

    protected List<Sample> createSamplesForMetric(Metric metric) {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (int i = 1; i <= 5; ++i) {
            samples.add(AbstractStorageIntegrationTest.createSampleForMetric(metric, i, this.referenceTime.minusSeconds(60L)));
        }
        return samples;
    }

    protected static Sample createSampleForMetric(Metric metric, int index, Instant referenceTime) {
        return ImmutableSample.builder().time(referenceTime.plus((long)index, ChronoUnit.SECONDS)).value(Double.valueOf(42.3)).metric(metric).build();
    }

    protected static List<Metric> createMetrics() {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (int i = 1; i < 5; ++i) {
            metrics.add(AbstractStorageIntegrationTest.createMetric(uuid, i));
        }
        return metrics;
    }

    protected static Metric createMetric(String uuid, int nodeId) {
        String mtype = nodeId % 2 == 0 ? Metric.Mtype.gauge.name() : Metric.Mtype.counter.name();
        return ImmutableMetric.builder().intrinsicTag("name", "n" + uuid).intrinsicTag("resourceId", String.format("snmp:%s:opennms-jvm:org_opennms_newts_name_ring_buffer_max_size_unit=unknown", nodeId)).metaTag("mtype", mtype).metaTag("host", "myHost" + nodeId).build();
    }
}

