/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries;

import com.google.re2j.Pattern;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.Aggregation;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.TagMatcher;
import org.opennms.integration.api.v1.timeseries.TimeSeriesData;
import org.opennms.integration.api.v1.timeseries.TimeSeriesFetchRequest;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableDataPoint;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTimeSeriesData;

public class InMemoryStorage
implements TimeSeriesStorage {
    private final Map<Metric, Collection<Sample>> data = new ConcurrentHashMap<Metric, Collection<Sample>>();

    public void store(List<Sample> samples) {
        Objects.requireNonNull(samples);
        for (Sample sample : samples) {
            Collection timeseries = this.data.computeIfAbsent(sample.getMetric(), k -> new ConcurrentLinkedQueue());
            timeseries.add(sample);
        }
    }

    public List<Metric> findMetrics(Collection<TagMatcher> tagMatchers) {
        Objects.requireNonNull(tagMatchers);
        if (tagMatchers.isEmpty()) {
            throw new IllegalArgumentException("We expect at least one TagMatcher but none was given.");
        }
        return this.data.keySet().stream().filter(metric -> this.matches(tagMatchers, (Metric)metric)).collect(Collectors.toList());
    }

    private boolean matches(Collection<TagMatcher> matchers, Metric metric) {
        HashSet searchableTags = new HashSet(metric.getIntrinsicTags());
        searchableTags.addAll(metric.getMetaTags());
        for (TagMatcher matcher : matchers) {
            if (!searchableTags.stream().noneMatch(t -> this.matches(matcher, (Tag)t))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(TagMatcher matcher, Tag tag) {
        if (!matcher.getKey().equals(tag.getKey())) {
            return false;
        }
        if (TagMatcher.Type.EQUALS == matcher.getType()) {
            return tag.getValue().equals(matcher.getValue());
        }
        if (TagMatcher.Type.NOT_EQUALS == matcher.getType()) {
            return !tag.getValue().equals(matcher.getValue());
        }
        if (TagMatcher.Type.EQUALS_REGEX == matcher.getType()) {
            return Pattern.matches((String)matcher.getValue(), (CharSequence)tag.getValue());
        }
        if (TagMatcher.Type.NOT_EQUALS_REGEX == matcher.getType()) {
            return !Pattern.matches((String)matcher.getValue(), (CharSequence)tag.getValue());
        }
        throw new IllegalArgumentException("Implement me for " + matcher.getType());
    }

    public List<Sample> getTimeseries(TimeSeriesFetchRequest request) throws StorageException {
        throw new UnsupportedOperationException("use getTimeSeriesData(TimeSeriesFetchRequest request) instead.");
    }

    public TimeSeriesData getTimeSeriesData(TimeSeriesFetchRequest request) {
        Objects.requireNonNull(request);
        if (request.getAggregation() != Aggregation.NONE) {
            throw new IllegalArgumentException(String.format("Aggregation %s is not supported.", request.getAggregation()));
        }
        List relevantSamples = Optional.ofNullable(this.data.get(request.getMetric())).stream().flatMap(Collection::stream).filter(sample -> sample.getTime().isAfter(request.getStart())).filter(sample -> sample.getTime().isBefore(request.getEnd())).collect(Collectors.toList());
        Metric metric = relevantSamples.isEmpty() ? request.getMetric() : ((Sample)relevantSamples.get(0)).getMetric();
        List dataPoints = relevantSamples.stream().map(s -> new ImmutableDataPoint(s.getTime(), s.getValue())).collect(Collectors.toList());
        return ImmutableTimeSeriesData.builder().metric(metric).dataPoints(dataPoints).build();
    }

    public void delete(Metric metric) {
        Objects.requireNonNull(metric);
        this.data.remove(metric);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Map<Metric, Collection<Sample>> getData() {
        return this.data;
    }
}

