/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.cortex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class EventTimestampIndexer {
    private final List<Instant> flushedEventTimestamps;

    private EventTimestampIndexer(List<Instant> flushedEventTimestamps) {
        this.flushedEventTimestamps = flushedEventTimestamps;
    }

    public EventTimestampIndexer() {
        this(new ArrayList<Instant>());
    }

    public int findIndex(Instant eventTimestamp) {
        int idx;
        for (idx = 0; idx < this.flushedEventTimestamps.size(); ++idx) {
            if (this.flushedEventTimestamps.get(idx).compareTo((ReadableInstant)eventTimestamp) >= 0) continue;
            this.flushedEventTimestamps.set(idx, eventTimestamp);
            return idx;
        }
        this.flushedEventTimestamps.add(eventTimestamp);
        return idx;
    }

    public Instant newestEventTimestamp() {
        return this.flushedEventTimestamps.get(0);
    }

    public static class EventTimestampIndexerCoder
    extends AtomicCoder<EventTimestampIndexer> {
        private static final Coder<List<Instant>> INSTANTS_CODER = ListCoder.of((Coder)InstantCoder.of());

        public static final EventTimestampIndexerCoder of() {
            return new EventTimestampIndexerCoder();
        }

        public void encode(EventTimestampIndexer value, OutputStream outStream) throws CoderException, IOException {
            INSTANTS_CODER.encode(value.flushedEventTimestamps, outStream);
        }

        public EventTimestampIndexer decode(InputStream inStream) throws CoderException, IOException {
            return new EventTimestampIndexer((List)INSTANTS_CODER.decode(inStream));
        }

        public boolean consistentWithEquals() {
            return INSTANTS_CODER.consistentWithEquals();
        }
    }
}

