/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.cortex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.opennms.nephron.cortex.EventTimestampIndexer;

public abstract class Heap<V> {
    abstract void add(V var1, Instant var2, Instant var3, BiFunction<V, V, V> var4);

    abstract boolean isEmpty();

    abstract Optional<Instant> oldestProcessingTimestamp();

    abstract Optional<Instant> newestEventTimestamp();

    abstract List<Flushed<V>> flush(Instant var1, Duration var2);

    static class HeapImpl<V>
    extends Heap<V> {
        private final EventTimestampIndexer eventTimestampIndexer;
        private final Map<Instant, HeapValue<V>> values;

        HeapImpl(EventTimestampIndexer eventTimestampIndexer, Map<Instant, HeapValue<V>> values) {
            this.eventTimestampIndexer = eventTimestampIndexer;
            this.values = values;
        }

        private int findIndex(Instant eventTimestamp) {
            return this.eventTimestampIndexer.findIndex(eventTimestamp);
        }

        @Override
        public void add(V value, Instant eventTimeTimestamp, Instant now, BiFunction<V, V, V> combiner) {
            HeapValue<V> heapValue = this.values.get(eventTimeTimestamp);
            if (heapValue != null) {
                heapValue.value = combiner.apply(heapValue.value, value);
            } else {
                heapValue = new HeapValue<V>(value, now);
                this.values.put(eventTimeTimestamp, heapValue);
            }
        }

        @Override
        boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        Optional<Instant> oldestProcessingTimestamp() {
            return this.values.values().stream().map(HeapValue::getCreated).min(AbstractInstant::compareTo);
        }

        @Override
        Optional<Instant> newestEventTimestamp() {
            return this.values.keySet().stream().max(AbstractInstant::compareTo);
        }

        @Override
        public List<Flushed<V>> flush(Instant now, Duration outputDelay) {
            Instant threshold = now.minus((ReadableDuration)outputDelay);
            ArrayList expired = new ArrayList();
            Iterator<Map.Entry<Instant, HeapValue<V>>> i = this.values.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Instant, HeapValue<V>> entry = i.next();
                if (entry.getValue().created.compareTo((ReadableInstant)threshold) > 0) continue;
                expired.add(new Flushed(entry.getValue().value, entry.getKey(), this.findIndex(entry.getKey())));
                i.remove();
            }
            if (expired.size() == 1) {
                return Collections.singletonList((Flushed)expired.get(0));
            }
            return expired.stream().sorted(Comparator.comparing(e -> e.eventTimestamp)).collect(Collectors.toList());
        }

        static class HeapImplCoder<V>
        extends StructuredCoder<HeapImpl<V>> {
            private final Coder<V> valueCoder;
            private final EventTimestampIndexer.EventTimestampIndexerCoder eventTimestampIndexerCoder;
            private final MapCoder<Instant, HeapValue<V>> mapCoder;

            public HeapImplCoder(Coder<V> valueCoder) {
                this.valueCoder = valueCoder;
                this.eventTimestampIndexerCoder = EventTimestampIndexer.EventTimestampIndexerCoder.of();
                this.mapCoder = MapCoder.of((Coder)InstantCoder.of(), new HeapValue.HeapValueCoder<V>(valueCoder));
            }

            public void encode(HeapImpl<V> value, OutputStream outStream) throws CoderException, IOException {
                this.eventTimestampIndexerCoder.encode(value.eventTimestampIndexer, outStream);
                this.mapCoder.encode(value.values, outStream);
            }

            public HeapImpl<V> decode(InputStream inStream) throws CoderException, IOException {
                return new HeapImpl(this.eventTimestampIndexerCoder.decode(inStream), this.mapCoder.decode(inStream));
            }

            public List<? extends Coder<?>> getCoderArguments() {
                return Collections.singletonList(this.valueCoder);
            }

            public void verifyDeterministic() throws Coder.NonDeterministicException {
                throw new Coder.NonDeterministicException((Coder)this, "Ordering of entries in the values Map may be non-deterministic.");
            }

            public boolean consistentWithEquals() {
                return this.eventTimestampIndexerCoder.consistentWithEquals() && this.mapCoder.consistentWithEquals();
            }

            public TypeDescriptor<HeapImpl<V>> getEncodedTypeDescriptor() {
                return new TypeDescriptor<HeapImpl<V>>(){}.where(new TypeParameter<V>(){}, this.valueCoder.getEncodedTypeDescriptor());
            }
        }

        private static class HeapValue<V> {
            private static Coder<Instant> INSTANT_CODER = InstantCoder.of();
            private V value;
            private Instant created;

            public HeapValue(V value, Instant created) {
                this.value = value;
                this.created = created;
            }

            public Instant getCreated() {
                return this.created;
            }

            private static class HeapValueCoder<V>
            extends AtomicCoder<HeapValue<V>> {
                private final Coder<V> valueCoder;

                public HeapValueCoder(Coder<V> valueCoder) {
                    this.valueCoder = valueCoder;
                }

                public void encode(HeapValue<V> value, OutputStream outStream) throws CoderException, IOException {
                    this.valueCoder.encode(value.value, outStream);
                    INSTANT_CODER.encode((Object)value.created, outStream);
                }

                public HeapValue<V> decode(InputStream inStream) throws CoderException, IOException {
                    return new HeapValue<Object>(this.valueCoder.decode(inStream), (Instant)INSTANT_CODER.decode(inStream));
                }
            }
        }
    }

    public static class Flushed<V> {
        public final V value;
        public final Instant eventTimestamp;
        public final int index;

        public Flushed(V value, Instant eventTimestamp, int index) {
            this.value = value;
            this.eventTimestamp = eventTimestamp;
            this.index = index;
        }
    }
}

