/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.opennms.nephron.catheter.Exporter;
import org.opennms.nephron.catheter.FlowGenerator;
import org.opennms.nephron.catheter.Simulation;
import org.opennms.nephron.catheter.json.ExporterJson;
import org.opennms.nephron.catheter.json.SimulationJson;
import org.opennms.nephron.generator.Handler;

public class Generator
implements Cloneable {
    @Argument
    private File jsonConfigFile;

    private void run(String ... args) throws IOException, JAXBException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            if (this.jsonConfigFile == null) {
                throw new CmdLineException(parser, "No argument is given");
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar catheter-1.0-SNAPSHOT-jar-with-dependencies.jar JSON-file");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            return;
        }
        Simulation simulation = Generator.fromFile(this.jsonConfigFile);
        simulation.start();
    }

    public static void main(String ... args) throws Exception {
        new Generator().run(args);
    }

    public static Simulation fromFile(File file) throws JAXBException, FileNotFoundException {
        return Generator.fromSource(new StreamSource(new FileReader(file)));
    }

    public static Simulation fromJson(String json) throws JAXBException {
        return Generator.fromSource(new StreamSource(new StringReader(json)));
    }

    private static Simulation fromSource(Source source) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{SimulationJson.class}).createUnmarshaller();
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        SimulationJson simulationJson = (SimulationJson)unmarshaller.unmarshal(source, SimulationJson.class).getValue();
        ArrayList<Exporter.Builder> exporterBuilders = new ArrayList<Exporter.Builder>();
        for (ExporterJson exporterJson : simulationJson.getExporters()) {
            FlowGenerator.Builder flowGeneratorBuilder = FlowGenerator.builder().withMaxFlowCount(exporterJson.getFlowGenerator().getMaxFlowCount()).withMinFlowDuration(Duration.ofMillis(exporterJson.getFlowGenerator().getMinFlowDurationMs())).withMaxFlowDuration(Duration.ofMillis(exporterJson.getFlowGenerator().getMaxFlowDurationMs())).withActiveTimeout(Duration.ofMillis(exporterJson.getFlowGenerator().getActiveTimeoutMs())).withBytesPerSecond(exporterJson.getFlowGenerator().getBytesPerSecond());
            exporterBuilders.add(Exporter.builder().withForeignId(exporterJson.getForeignId()).withForeignSource(exporterJson.getForeignSource()).withNodeId(exporterJson.getNodeId()).withLocation(exporterJson.getLocation()).withInputSnmp(exporterJson.getInputSnmp()).withOutputSnmp(exporterJson.getOutputSnmp()).withGenerator(flowGeneratorBuilder).withClockOffset(Duration.ofMillis(exporterJson.getClockOffsetMs())));
        }
        Handler handler = new Handler(simulationJson.getBootstrapServers(), simulationJson.getFlowTopic(), new Random(simulationJson.getSeed()));
        return Simulation.builder((BiConsumer)handler).withStartTime(simulationJson.getStartTime()).withSeed(simulationJson.getSeed()).withTickMs(Duration.ofMillis(simulationJson.getTickMs())).withRealtime(simulationJson.getRealtime()).withExporters(exporterBuilders).build();
    }
}

