/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.generator;

import com.google.common.net.InetAddresses;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opennms.nephron.catheter.Exporter;
import org.opennms.nephron.catheter.FlowReport;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;
import org.opennms.netmgt.flows.persistence.model.Locality;
import org.opennms.netmgt.flows.persistence.model.NodeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
implements BiConsumer<Exporter, FlowReport>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Handler.class);
    private final KafkaProducer<String, byte[]> kafkaProducer;
    private final String flowTopic;
    private final Random random;
    private final List<Integer> protocols;
    private final List<String> applications;
    private final List<String> hosts;
    private final List<AddrHost> addresses;

    public Handler(String bootstrapServers, String flowTopic, Random random) {
        this(bootstrapServers, flowTopic, random, null);
    }

    public Handler(String bootstrapServers, String flowTopic, Random random, File propertiesFile) {
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        if (propertiesFile != null) {
            try {
                Properties properties = new Properties();
                properties.load(new FileReader(propertiesFile));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    producerProps.put(entry.getKey().toString(), entry.getValue());
                }
            }
            catch (IOException e) {
                LOG.error("Error reading properties file", (Throwable)e);
                throw new RuntimeException("Error reading properties file", e);
            }
        }
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("key.serializer", StringSerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        this.kafkaProducer = new KafkaProducer(producerProps);
        this.flowTopic = flowTopic;
        this.random = random;
        this.protocols = Arrays.asList(6, 17);
        this.applications = this.generate(200, this.generateString(15));
        this.hosts = this.generate(5, this.generateString(10));
        this.addresses = this.generate(100, () -> new AddrHost(this.generateInetAddr().get(), this.generateString(10).get()));
    }

    @Override
    public void accept(Exporter exporter, FlowReport report) {
        FlowDocument flowDocument = this.createFlowDocument(exporter, report);
        this.kafkaProducer.send(new ProducerRecord(this.flowTopic, (Object)flowDocument.toByteArray()), (metadata, exception) -> {
            if (exception != null) {
                LOG.warn("Simulation: error sending flow document to Kafka topic", (Throwable)exception);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.kafkaProducer.close();
    }

    private FlowDocument createFlowDocument(Exporter exporter, FlowReport report) {
        InetAddress[] inetAddressArray;
        int protocol = this.choose(this.protocols);
        String application = this.choose(this.applications);
        AddrHost srcAddr = this.choose(this.addresses);
        AddrHost dstAddr = this.choose(this.addresses);
        if (InetAddresses.coerceToInteger((InetAddress)srcAddr.address) < InetAddresses.coerceToInteger((InetAddress)dstAddr.address)) {
            InetAddress[] inetAddressArray2 = new InetAddress[2];
            inetAddressArray2[0] = srcAddr.address;
            inetAddressArray = inetAddressArray2;
            inetAddressArray2[1] = dstAddr.address;
        } else {
            InetAddress[] inetAddressArray3 = new InetAddress[2];
            inetAddressArray3[0] = dstAddr.address;
            inetAddressArray = inetAddressArray3;
            inetAddressArray3[1] = srcAddr.address;
        }
        InetAddress[] convo = inetAddressArray;
        FlowDocument.Builder flowBuilder = FlowDocument.newBuilder();
        flowBuilder.setApplication(application);
        flowBuilder.setHost(this.choose(this.hosts));
        flowBuilder.setLocation(exporter.getLocation());
        flowBuilder.setDstLocality(Locality.PUBLIC);
        flowBuilder.setSrcLocality(Locality.PUBLIC);
        flowBuilder.setFlowLocality(Locality.PUBLIC);
        flowBuilder.setSrcAddress(InetAddresses.toAddrString((InetAddress)srcAddr.address));
        flowBuilder.setDstAddress(InetAddresses.toAddrString((InetAddress)dstAddr.address));
        flowBuilder.setSrcHostname(srcAddr.hostname);
        flowBuilder.setDstHostname(dstAddr.hostname);
        flowBuilder.setFirstSwitched(UInt64Value.of((long)report.getStart().plus(exporter.getClockOffset()).toEpochMilli()));
        flowBuilder.setDeltaSwitched(UInt64Value.of((long)report.getStart().plus(exporter.getClockOffset()).toEpochMilli()));
        flowBuilder.setLastSwitched(UInt64Value.of((long)report.getEnd().minusMillis(1L).plus(exporter.getClockOffset()).toEpochMilli()));
        flowBuilder.setNumBytes(UInt64Value.of((long)report.getBytes()));
        flowBuilder.setInputSnmpIfindex(UInt32Value.of((int)exporter.getInputSnmp()));
        flowBuilder.setOutputSnmpIfindex(UInt32Value.of((int)exporter.getOutputSnmp()));
        NodeInfo.Builder exporterBuilder = NodeInfo.newBuilder();
        exporterBuilder.setNodeId(exporter.getNodeId());
        exporterBuilder.setForeignSource(exporter.getForeignSource());
        exporterBuilder.setForeginId(exporter.getForeignId());
        flowBuilder.setExporterNode(exporterBuilder);
        return flowBuilder.build();
    }

    private Supplier<String> generateString(int length) {
        return () -> this.random.ints(97, 123).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private <T> List<T> generate(int count, Supplier<T> f) {
        return IntStream.range(0, count).mapToObj(i -> f.get()).collect(Collectors.toList());
    }

    private Supplier<Inet4Address> generateInetAddr() {
        return () -> InetAddresses.fromInteger((int)this.random.nextInt());
    }

    private <T> T choose(List<T> options) {
        return options.get(this.random.nextInt(options.size()));
    }

    private static class AddrHost {
        public final InetAddress address;
        public final String hostname;

        private AddrHost(InetAddress address, String hostname) {
            this.address = Objects.requireNonNull(address);
            this.hostname = Objects.requireNonNull(hostname);
        }
    }
}

