/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.opennms.nephron.CompoundKeyType;
import org.opennms.nephron.Ref;
import org.opennms.nephron.elastic.FlowSummary;

@DefaultCoder(value=CompoundKeyCoder.class)
public class CompoundKey {
    private final CompoundKeyType type;
    private final List<Ref> refs;
    private static final Coder<Integer> INT_CODER = NullableCoder.of((Coder)VarIntCoder.of());

    CompoundKey(CompoundKeyType type, List<Ref> refs) {
        if (type.getParts().length != refs.size()) {
            throw new RuntimeException("size of compound key type parts and given refs do not match - #parts: " + type.getParts().length + "; #refs: " + refs.size());
        }
        this.type = type;
        this.refs = refs;
    }

    public CompoundKeyType getType() {
        return this.type;
    }

    public List<Ref> getRefs() {
        return this.refs;
    }

    public CompoundKey getOuterKey() {
        return this.type.getParent() == null ? null : new CompoundKey(this.type.getParent(), this.refs.subList(0, this.type.getParent().getParts().length));
    }

    public CompoundKey project(CompoundKeyType projectedType) {
        ArrayList<Ref> l = new ArrayList<Ref>();
        int j = 0;
        for (int i = 0; i < this.type.getParts().length; ++i) {
            if (this.type.getParts()[i] != projectedType.getParts()[j]) continue;
            l.add(this.refs.get(i));
            ++j;
        }
        if (j != projectedType.getParts().length) {
            throw new RuntimeException("key of type " + (Object)((Object)this.type) + " can not be project into key of type " + (Object)((Object)projectedType));
        }
        return new CompoundKey(projectedType, l);
    }

    public String groupedByKey() {
        return this.refs.stream().map(Ref::idAsString).collect(Collectors.joining("-"));
    }

    public void populate(FlowSummary flow) {
        flow.setGroupedBy(this.type);
        flow.setGroupedByKey(this.groupedByKey());
        for (int i = 0; i < this.type.getParts().length; ++i) {
            this.type.getParts()[i].populate(this.refs.get(i), flow);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundKey cKey = (CompoundKey)o;
        return this.type == cKey.type && Objects.equals(this.refs, cKey.refs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.refs});
    }

    public String toString() {
        return "CompoundKey{type=" + (Object)((Object)this.type) + ", refs=" + this.refs + '}';
    }

    public static class CompoundKeyCoder
    extends AtomicCoder<CompoundKey> {
        public void encode(CompoundKey value, OutputStream outStream) throws IOException {
            INT_CODER.encode((Object)value.getType().ordinal(), outStream);
            value.getType().encode(value.getRefs(), outStream);
        }

        public CompoundKey decode(InputStream inStream) throws IOException {
            CompoundKeyType type = CompoundKeyType.values()[(Integer)INT_CODER.decode(inStream)];
            return type.decode(inStream);
        }

        public boolean consistentWithEquals() {
            return true;
        }
    }
}

