/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;
import org.opennms.nephron.elastic.IndexStrategy;

public interface NephronOptions
extends PipelineOptions {
    public static final String DEFAULT_NETFLOW_AGG_INDEX_PREFIX = "netflow_agg";
    public static final String DEFAULT_FLOW_SOURCE_TOPIC = "opennms-flows";

    @Description(value="Kafka Bootstrap Servers")
    @Default.String(value="localhost:9092")
    public String getBootstrapServers();

    public void setBootstrapServers(String var1);

    @Description(value="Kafka Consumer Group ID")
    @Default.String(value="opennms-nephron")
    public String getGroupId();

    public void setGroupId(String var1);

    @Description(value="Enable/disable auto-commit for the Kafka consumer. Should be enabled when checkpointing is disabled.")
    @Default.Boolean(value=true)
    public boolean getAutoCommit();

    public void setAutoCommit(boolean var1);

    @Description(value="Source topic for flows")
    @Default.String(value="opennms-flows")
    public String getFlowSourceTopic();

    public void setFlowSourceTopic(String var1);

    @Description(value="Destination topic for aggregated flows")
    public String getFlowDestTopic();

    public void setFlowDestTopic(String var1);

    @Description(value="Size of the window in milliseconds")
    @Default.Long(value=60000L)
    @Validation.Required
    public long getFixedWindowSizeMs();

    public void setFixedWindowSizeMs(long var1);

    @Description(value="Top K")
    @Default.Integer(value=10)
    public int getTopK();

    public void setTopK(int var1);

    @Description(value="Elasticsearch URL")
    @Default.String(value="http://localhost:9200")
    public String getElasticUrl();

    public void setElasticUrl(String var1);

    @Description(value="Elasticsearch Username")
    public String getElasticUser();

    public void setElasticUser(String var1);

    @Description(value="Elasticsearch Password")
    public String getElasticPassword();

    public void setElasticPassword(String var1);

    @Description(value="Elasticsearch Index Strategy")
    @Default.Enum(value="MONTHLY")
    public IndexStrategy getElasticIndexStrategy();

    public void setElasticIndexStrategy(IndexStrategy var1);

    @Description(value="Elasticsearch Flow Index")
    @Default.String(value="netflow_agg")
    public String getElasticFlowIndex();

    public void setElasticFlowIndex(String var1);

    @Description(value="Max input delay in milliseconds. Messages received from a Kafka topic are expected to be delayed by no more than this duration when compared to the latest timestamp observed, or the current time if there is no backlog.")
    @Default.Long(value=120000L)
    public long getDefaultMaxInputDelayMs();

    public void setDefaultMaxInputDelayMs(long var1);

    @Description(value="Max amount of time a flow is expected to last (last_switched - delta_switched). Flows that last longer than this duration will be ignored and a warning will be logged.")
    @Default.Long(value=900000L)
    public long getMaxFlowDurationMs();

    public void setMaxFlowDurationMs(long var1);

    @Description(value="Amount of time to wait before firing the pane for early updates.Decrease this value for faster updates, at the cost of more update being fired. Set to 0 to disable.")
    @Default.Long(value=0L)
    public long getEarlyProcessingDelayMs();

    public void setEarlyProcessingDelayMs(long var1);

    @Description(value="Amount of time to wait before firing the pane after late data has arrived.Decrease this value for faster updates, at the cost of more update being fired.")
    @Default.Long(value=60000L)
    public long getLateProcessingDelayMs();

    public void setLateProcessingDelayMs(long var1);

    @Description(value="Max amount of time to wait for late flows to appear. Changing this value will affect state size (less state to keep for smaller values) and the ability to process late data.")
    @Default.Long(value=14400000L)
    public long getAllowedLatenessMs();

    public void setAllowedLatenessMs(long var1);

    @Description(value="Elasticsearch Connection Timeout in milliseconds")
    @Default.Integer(value=30000)
    public int getElasticConnectTimeout();

    public void setElasticConnectTimeout(int var1);

    @Description(value="Elasticsearch Socket Timeout in milliseconds")
    @Default.Integer(value=30000)
    public int getElasticSocketTimeout();

    public void setElasticSocketTimeout(int var1);

    @Description(value="Elasticsearch Retry Count")
    @Default.Integer(value=3)
    public int getElasticRetryCount();

    public void setElasticRetryCount(int var1);

    @Description(value="Elasticsearch Retry Duration")
    @Default.Long(value=3000L)
    public long getElasticRetryDuration();

    public void setElasticRetryDuration(long var1);

    @Description(value="Path to Kafka client properties file")
    public String getKafkaClientProperties();

    public void setKafkaClientProperties(String var1);
}

