/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import com.google.common.base.Strings;
import java.util.Objects;
import org.opennms.nephron.MissingFieldsException;
import org.opennms.netmgt.flows.persistence.model.Direction;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;
import org.opennms.netmgt.flows.persistence.model.NodeInfo;

abstract class Ref {
    Ref() {
    }

    abstract String idAsString();

    public static class Conversation
    extends Ref {
        private String conversationKey;

        public static Conversation of(String conversationKey) {
            Conversation conversationRef = new Conversation();
            conversationRef.setConversationKey(conversationKey);
            return conversationRef;
        }

        public static Conversation of(FlowDocument flow) {
            return Conversation.of(flow.getConvoKey());
        }

        public String getConversationKey() {
            return this.conversationKey;
        }

        public void setConversationKey(String conversationKey) {
            this.conversationKey = conversationKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Conversation that = (Conversation)o;
            return Objects.equals(this.conversationKey, that.conversationKey);
        }

        public int hashCode() {
            return Objects.hash(this.conversationKey);
        }

        public String toString() {
            return "ConversationRef{conversationKey='" + this.conversationKey + '\'' + '}';
        }

        @Override
        public String idAsString() {
            return this.conversationKey;
        }
    }

    public static class Host
    extends Ref {
        private String address;

        public static Host of(String address) {
            Host hostRef = new Host();
            hostRef.setAddress(address);
            return hostRef;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Host hostRef = (Host)o;
            return Objects.equals(this.address, hostRef.address);
        }

        public int hashCode() {
            return Objects.hash(this.address);
        }

        public String toString() {
            return "HostRef{address='" + this.address + '\'' + '}';
        }

        @Override
        public String idAsString() {
            return this.address;
        }
    }

    public static class Application
    extends Ref {
        private String application;

        public static Application of(String application) {
            Application applicationRef = new Application();
            applicationRef.setApplication(application);
            return applicationRef;
        }

        public static Application of(FlowDocument flow) {
            String application = flow.getApplication();
            return Strings.isNullOrEmpty((String)application) ? Application.of("__unknown") : Application.of(application);
        }

        public String getApplication() {
            return this.application;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Application that = (Application)o;
            return Objects.equals(this.application, that.application);
        }

        public int hashCode() {
            return Objects.hash(this.application);
        }

        public String toString() {
            return "ApplicationRef{application='" + this.application + '\'' + '}';
        }

        @Override
        public String idAsString() {
            return this.application;
        }
    }

    public static class Dscp
    extends Ref {
        private int dscp;
        public static int DEFAULT_CODE = 0;

        public static Dscp of(FlowDocument flow) {
            int dscp = flow.hasDscp() ? flow.getDscp().getValue() : DEFAULT_CODE;
            return new Dscp(dscp);
        }

        public Dscp(int dscp) {
            this.dscp = dscp;
        }

        public int getDscp() {
            return this.dscp;
        }

        public void setDscp(int dscp) {
            this.dscp = dscp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dscp dscpRef = (Dscp)o;
            return this.dscp == dscpRef.dscp;
        }

        public int hashCode() {
            return Objects.hash(this.dscp);
        }

        public String toString() {
            return "DscpRef{dscp=" + this.dscp + '}';
        }

        @Override
        public String idAsString() {
            return Integer.toString(this.dscp);
        }
    }

    public static class Interface
    extends Ref {
        private int ifIndex;

        public static Interface of(int ifIndex) {
            Interface interfaceRef = new Interface();
            interfaceRef.setIfIndex(ifIndex);
            return interfaceRef;
        }

        public static Interface of(FlowDocument flow) {
            if (Direction.INGRESS.equals((Object)flow.getDirection())) {
                return Interface.of(flow.getInputSnmpIfindex().getValue());
            }
            return Interface.of(flow.getOutputSnmpIfindex().getValue());
        }

        public int getIfIndex() {
            return this.ifIndex;
        }

        public void setIfIndex(int ifIndex) {
            this.ifIndex = ifIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interface that = (Interface)o;
            return this.ifIndex == that.ifIndex;
        }

        public int hashCode() {
            return Objects.hash(this.ifIndex);
        }

        public String toString() {
            return "InterfaceRef{ifIndex=" + this.ifIndex + '}';
        }

        @Override
        public String idAsString() {
            return Integer.toString(this.ifIndex);
        }
    }

    public static class Node
    extends Ref {
        private String foreignSource;
        private String foreignId;
        private Integer nodeId;

        public static Node of(int nodeId, String foreignSource, String foreignId) {
            Node nodeRef = new Node();
            nodeRef.setNodeId(nodeId);
            nodeRef.setForeignSource(foreignSource);
            nodeRef.setForeignId(foreignId);
            return nodeRef;
        }

        public static Node of(int nodeId) {
            Node nodeRef = new Node();
            nodeRef.setNodeId(nodeId);
            return nodeRef;
        }

        public static Node of(FlowDocument flow) throws MissingFieldsException {
            if (!flow.hasExporterNode()) {
                throw new MissingFieldsException("exporterNode", flow);
            }
            NodeInfo exporterNode = flow.getExporterNode();
            if (!Strings.isNullOrEmpty((String)exporterNode.getForeignSource()) && !Strings.isNullOrEmpty((String)exporterNode.getForeginId())) {
                return Node.of(exporterNode.getNodeId(), exporterNode.getForeignSource(), exporterNode.getForeginId());
            }
            return Node.of(exporterNode.getNodeId());
        }

        public String getForeignSource() {
            return this.foreignSource;
        }

        public void setForeignSource(String foreignSource) {
            this.foreignSource = foreignSource;
        }

        public String getForeignId() {
            return this.foreignId;
        }

        public void setForeignId(String foreignId) {
            this.foreignId = foreignId;
        }

        public Integer getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(Integer nodeId) {
            this.nodeId = nodeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node nodeRef = (Node)o;
            return Objects.equals(this.foreignSource, nodeRef.foreignSource) && Objects.equals(this.foreignId, nodeRef.foreignId) && Objects.equals(this.nodeId, nodeRef.nodeId);
        }

        public int hashCode() {
            return Objects.hash(this.foreignSource, this.foreignId, this.nodeId);
        }

        public String toString() {
            return "NodeRef{foreignSource='" + this.foreignSource + '\'' + ", foreignId='" + this.foreignId + '\'' + ", nodeId=" + this.nodeId + '}';
        }

        @Override
        public String idAsString() {
            if (this.foreignSource != null) {
                return this.foreignSource + ":" + this.foreignId;
            }
            return Integer.toString(this.nodeId);
        }
    }
}

