/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.opennms.nephron.MissingFieldsException;
import org.opennms.nephron.Ref;
import org.opennms.nephron.WithHostname;
import org.opennms.nephron.elastic.ExporterNode;
import org.opennms.nephron.elastic.FlowSummary;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;

abstract class RefType<T extends Ref> {
    private static final Coder<String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final Coder<Integer> INT_CODER = NullableCoder.of((Coder)VarIntCoder.of());
    public static final RefType<Ref.Node> EXPORTER_PART = new RefType<Ref.Node>(){

        @Override
        public void encode(Ref.Node ref, OutputStream os) throws IOException {
            STRING_CODER.encode((Object)ref.getForeignSource(), os);
            STRING_CODER.encode((Object)ref.getForeignId(), os);
            INT_CODER.encode((Object)ref.getNodeId(), os);
        }

        @Override
        public Ref.Node decode(InputStream is) throws IOException {
            Ref.Node ref = new Ref.Node();
            ref.setForeignSource((String)STRING_CODER.decode(is));
            ref.setForeignId((String)STRING_CODER.decode(is));
            ref.setNodeId((Integer)INT_CODER.decode(is));
            return ref;
        }

        @Override
        public List<WithHostname<Ref.Node>> create(FlowDocument flow) throws MissingFieldsException {
            return RefType.singlePartWithoutHostName(Ref.Node.of(flow));
        }

        @Override
        public void populate(Ref.Node ref, FlowSummary summary) {
            ExporterNode exporterNode = new ExporterNode();
            exporterNode.setForeignSource(ref.getForeignSource());
            exporterNode.setForeignId(ref.getForeignId());
            exporterNode.setNodeId(ref.getNodeId());
            summary.setExporter(exporterNode);
        }
    };
    public static final RefType<Ref.Interface> INTERFACE_PART = new RefType<Ref.Interface>(){

        @Override
        public void encode(Ref.Interface ref, OutputStream os) throws IOException {
            INT_CODER.encode((Object)ref.getIfIndex(), os);
        }

        @Override
        public Ref.Interface decode(InputStream is) throws IOException {
            Ref.Interface ref = new Ref.Interface();
            ref.setIfIndex((Integer)INT_CODER.decode(is));
            return ref;
        }

        @Override
        public List<WithHostname<Ref.Interface>> create(FlowDocument flow) throws MissingFieldsException {
            return RefType.singlePartWithoutHostName(Ref.Interface.of(flow));
        }

        @Override
        public void populate(Ref.Interface ref, FlowSummary summary) {
            summary.setIfIndex(ref.getIfIndex());
        }
    };
    public static final RefType<Ref.Dscp> DSCP_PART = new RefType<Ref.Dscp>(){

        @Override
        public void encode(Ref.Dscp ref, OutputStream os) throws IOException {
            INT_CODER.encode((Object)ref.getDscp(), os);
        }

        @Override
        public Ref.Dscp decode(InputStream is) throws IOException {
            return new Ref.Dscp((Integer)INT_CODER.decode(is));
        }

        @Override
        public List<WithHostname<Ref.Dscp>> create(FlowDocument flow) throws MissingFieldsException {
            return RefType.singlePartWithoutHostName(Ref.Dscp.of(flow));
        }

        @Override
        public void populate(Ref.Dscp ref, FlowSummary summary) {
            summary.setDscp(ref.getDscp());
        }
    };
    public static final RefType<Ref.Application> APPLICATION_PART = new RefType<Ref.Application>(){

        @Override
        public void encode(Ref.Application ref, OutputStream os) throws IOException {
            STRING_CODER.encode((Object)ref.getApplication(), os);
        }

        @Override
        public Ref.Application decode(InputStream is) throws IOException {
            Ref.Application ref = new Ref.Application();
            ref.setApplication((String)STRING_CODER.decode(is));
            return ref;
        }

        @Override
        public List<WithHostname<Ref.Application>> create(FlowDocument flow) throws MissingFieldsException {
            return RefType.singlePartWithoutHostName(Ref.Application.of(flow));
        }

        @Override
        public void populate(Ref.Application ref, FlowSummary summary) {
            summary.setApplication(ref.getApplication());
        }
    };
    public static final RefType<Ref.Host> HOST_PART = new RefType<Ref.Host>(){

        @Override
        public void encode(Ref.Host ref, OutputStream os) throws IOException {
            STRING_CODER.encode((Object)ref.getAddress(), os);
        }

        @Override
        public Ref.Host decode(InputStream is) throws IOException {
            Ref.Host ref = new Ref.Host();
            ref.setAddress((String)STRING_CODER.decode(is));
            return ref;
        }

        @Override
        public List<WithHostname<Ref.Host>> create(FlowDocument flow) throws MissingFieldsException {
            return Arrays.asList(WithHostname.having(Ref.Host.of(flow.getSrcAddress())).andHostname(flow.getSrcHostname()), WithHostname.having(Ref.Host.of(flow.getDstAddress())).andHostname(flow.getDstHostname()));
        }

        @Override
        public void populate(Ref.Host ref, FlowSummary summary) {
            summary.setHostAddress(ref.getAddress());
        }
    };
    public static final RefType<Ref.Conversation> CONVERSATION_PART = new RefType<Ref.Conversation>(){

        @Override
        public void encode(Ref.Conversation ref, OutputStream os) throws IOException {
            STRING_CODER.encode((Object)ref.getConversationKey(), os);
        }

        @Override
        public Ref.Conversation decode(InputStream is) throws IOException {
            Ref.Conversation ref = new Ref.Conversation();
            ref.setConversationKey((String)STRING_CODER.decode(is));
            return ref;
        }

        @Override
        public List<WithHostname<Ref.Conversation>> create(FlowDocument flow) throws MissingFieldsException {
            return RefType.singlePartWithoutHostName(Ref.Conversation.of(flow));
        }

        @Override
        public void populate(Ref.Conversation ref, FlowSummary summary) {
            summary.setConversationKey(ref.getConversationKey());
        }
    };

    RefType() {
    }

    public abstract void encode(T var1, OutputStream var2) throws IOException;

    public abstract T decode(InputStream var1) throws IOException;

    public abstract List<WithHostname<T>> create(FlowDocument var1) throws MissingFieldsException;

    public abstract void populate(T var1, FlowSummary var2);

    private static <T> List<WithHostname<T>> singlePartWithoutHostName(T t) {
        return Collections.singletonList(WithHostname.having(t).withoutHostname());
    }
}

