/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;

@DefaultCoder(value=AggregateCoder.class)
public class Aggregate {
    private long bytesIn;
    private long bytesOut;
    private String hostname;
    private boolean congestionEncountered;
    private boolean nonEcnCapableTransport;

    public Aggregate(long bytesIn, long bytesOut, String hostname, boolean ce, boolean nonEct) {
        this.bytesIn = bytesIn;
        this.bytesOut = bytesOut;
        this.hostname = hostname;
        this.congestionEncountered = ce;
        this.nonEcnCapableTransport = nonEct;
    }

    public Aggregate(long bytesIn, long bytesOut, String hostname, Integer ecn) {
        this.bytesIn = bytesIn;
        this.bytesOut = bytesOut;
        this.hostname = hostname;
        if (ecn != null) {
            this.congestionEncountered = ecn == 3;
            this.nonEcnCapableTransport = ecn == 0;
        } else {
            this.congestionEncountered = false;
            this.nonEcnCapableTransport = true;
        }
    }

    public static Aggregate merge(Aggregate a, Aggregate b) {
        return new Aggregate(a.bytesIn + b.bytesIn, a.bytesOut + b.bytesOut, a.hostname != null ? a.hostname : b.hostname, a.congestionEncountered || b.congestionEncountered, a.nonEcnCapableTransport || b.nonEcnCapableTransport);
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public String getHostname() {
        return this.hostname;
    }

    public long getBytes() {
        return this.bytesIn + this.bytesOut;
    }

    public boolean isCongestionEncountered() {
        return this.congestionEncountered;
    }

    public boolean isNonEcnCapableTransport() {
        return this.nonEcnCapableTransport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Aggregate)) {
            return false;
        }
        Aggregate flowBytes = (Aggregate)o;
        return this.bytesIn == flowBytes.bytesIn && this.bytesOut == flowBytes.bytesOut && this.congestionEncountered == flowBytes.congestionEncountered && this.nonEcnCapableTransport == flowBytes.nonEcnCapableTransport && Objects.equals(this.hostname, flowBytes.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.bytesIn, this.bytesOut, this.hostname, this.congestionEncountered, this.nonEcnCapableTransport);
    }

    public String toString() {
        return "Aggregate{bytesIn=" + this.bytesIn + ", bytesOut=" + this.bytesOut + ", hostname='" + this.hostname + '\'' + ", congestionEncountered=" + this.congestionEncountered + ", nonEcnCapableTransport=" + this.nonEcnCapableTransport + '}';
    }

    public static class AggregateCoder
    extends AtomicCoder<Aggregate> {
        private final Coder<Long> LONG_CODER = VarLongCoder.of();
        private final Coder<String> STRING_CODER = StringUtf8Coder.of();
        private final Coder<Boolean> BOOLEAN_CODER = BooleanCoder.of();

        public void encode(Aggregate value, OutputStream outStream) throws IOException {
            this.LONG_CODER.encode((Object)value.bytesIn, outStream);
            this.LONG_CODER.encode((Object)value.bytesOut, outStream);
            this.STRING_CODER.encode((Object)Strings.nullToEmpty((String)value.hostname), outStream);
            this.BOOLEAN_CODER.encode((Object)value.congestionEncountered, outStream);
            this.BOOLEAN_CODER.encode((Object)value.nonEcnCapableTransport, outStream);
        }

        public Aggregate decode(InputStream inStream) throws IOException {
            long bytesIn = (Long)this.LONG_CODER.decode(inStream);
            long bytesOut = (Long)this.LONG_CODER.decode(inStream);
            String hostname = (String)this.STRING_CODER.decode(inStream);
            boolean congestionEncountered = (Boolean)this.BOOLEAN_CODER.decode(inStream);
            boolean nonEcnCapableTransport = (Boolean)this.BOOLEAN_CODER.decode(inStream);
            return new Aggregate(bytesIn, bytesOut, Strings.emptyToNull((String)hostname), congestionEncountered, nonEcnCapableTransport);
        }

        public boolean consistentWithEquals() {
            return true;
        }
    }
}

