/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ArrayUtils;
import org.opennms.nephron.CompoundKey;
import org.opennms.nephron.MissingFieldsException;
import org.opennms.nephron.Ref;
import org.opennms.nephron.RefType;
import org.opennms.nephron.WithHostname;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;

public enum CompoundKeyType {
    EXPORTER(null, RefType.EXPORTER_PART),
    EXPORTER_INTERFACE(EXPORTER, RefType.INTERFACE_PART),
    EXPORTER_INTERFACE_APPLICATION(EXPORTER_INTERFACE, RefType.APPLICATION_PART),
    EXPORTER_INTERFACE_CONVERSATION(EXPORTER_INTERFACE, RefType.CONVERSATION_PART),
    EXPORTER_INTERFACE_HOST(EXPORTER_INTERFACE, RefType.HOST_PART),
    EXPORTER_INTERFACE_TOS(EXPORTER_INTERFACE, RefType.DSCP_PART),
    EXPORTER_INTERFACE_TOS_APPLICATION(EXPORTER_INTERFACE_TOS, RefType.APPLICATION_PART),
    EXPORTER_INTERFACE_TOS_CONVERSATION(EXPORTER_INTERFACE_TOS, RefType.CONVERSATION_PART),
    EXPORTER_INTERFACE_TOS_HOST(EXPORTER_INTERFACE_TOS, RefType.HOST_PART);

    private CompoundKeyType parent;
    private RefType<Ref>[] parts;

    private CompoundKeyType(CompoundKeyType parent, RefType<? extends Ref> ... parts) {
        this.parent = parent;
        this.parts = parent == null ? parts : (RefType[])ArrayUtils.addAll((Object[])parent.parts, (Object[])parts);
    }

    public CompoundKeyType getParent() {
        return this.parent;
    }

    public RefType<Ref>[] getParts() {
        return this.parts;
    }

    CompoundKey decode(InputStream is) throws IOException {
        ArrayList<Ref> refs = new ArrayList<Ref>(this.parts.length);
        for (int i = 0; i < this.parts.length; ++i) {
            refs.add(this.parts[i].decode(is));
        }
        return new CompoundKey(this, refs);
    }

    void encode(List<Ref> refs, OutputStream os) throws IOException {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].encode(refs.get(i), os);
        }
    }

    List<WithHostname<CompoundKey>> create(FlowDocument flow) throws MissingFieldsException {
        List refss = null;
        for (RefType<Ref> part : this.parts) {
            List<WithHostname<Ref>> refs2 = part.create(flow);
            if (refss == null) {
                refss = refs2.stream().map(whn -> Collections.singletonList(whn)).collect(Collectors.toList());
                continue;
            }
            ArrayList next = new ArrayList();
            for (List prefix : refss) {
                for (WithHostname<Ref> suffix : refs2) {
                    ArrayList<WithHostname<Ref>> l = new ArrayList<WithHostname<Ref>>();
                    l.addAll(prefix);
                    l.add(suffix);
                    next.add(l);
                }
            }
            refss = next;
        }
        return refss.stream().map(refs -> {
            String hostname = ((WithHostname)refs.get((int)(refs.size() - 1))).hostname;
            CompoundKey key = new CompoundKey(this, refs.stream().map(whn -> (Ref)whn.value).collect(Collectors.toList()));
            return WithHostname.having(key).andHostname(hostname);
        }).collect(Collectors.toList());
    }
}

