/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.opennms.nephron.Aggregate;
import org.opennms.nephron.CompoundKey;
import org.opennms.nephron.elastic.AggregationType;

@DefaultCoder(value=FlowSummaryDataCoder.class)
public class FlowSummaryData {
    public final AggregationType aggregationType;
    public final CompoundKey key;
    public final Aggregate aggregate;
    public final long windowStart;
    public final long windowEnd;
    public final int ranking;

    public FlowSummaryData(AggregationType aggregationType, CompoundKey key, Aggregate aggregate, long windowStart, long windowEnd, int ranking) {
        this.aggregationType = aggregationType;
        this.key = key;
        this.aggregate = aggregate;
        this.windowStart = windowStart;
        this.windowEnd = windowEnd;
        this.ranking = ranking;
    }

    public String toString() {
        return "FlowSummaryData{aggregationType=" + (Object)((Object)this.aggregationType) + ", key=" + this.key + ", aggregate=" + this.aggregate + ", windowStart=" + this.windowStart + ", windowEnd=" + this.windowEnd + ", ranking=" + this.ranking + '}';
    }

    public static class FlowSummaryDataCoder
    extends AtomicCoder<FlowSummaryData> {
        private static Coder<Integer> INT_CODER = VarIntCoder.of();
        private static Coder<Long> LONG_CODER = VarLongCoder.of();
        private static Coder<CompoundKey> KEY_CODER = new CompoundKey.CompoundKeyCoder();
        private static Coder<Aggregate> AGG_CODER = new Aggregate.AggregateCoder();

        public void encode(FlowSummaryData value, OutputStream outStream) throws IOException {
            INT_CODER.encode((Object)value.aggregationType.ordinal(), outStream);
            KEY_CODER.encode((Object)value.key, outStream);
            AGG_CODER.encode((Object)value.aggregate, outStream);
            LONG_CODER.encode((Object)value.windowStart, outStream);
            LONG_CODER.encode((Object)value.windowEnd, outStream);
            INT_CODER.encode((Object)value.ranking, outStream);
        }

        public FlowSummaryData decode(InputStream inStream) throws IOException {
            return new FlowSummaryData(AggregationType.values()[(Integer)INT_CODER.decode(inStream)], (CompoundKey)KEY_CODER.decode(inStream), (Aggregate)AGG_CODER.decode(inStream), (Long)LONG_CODER.decode(inStream), (Long)LONG_CODER.decode(inStream), (Integer)INT_CODER.decode(inStream));
        }
    }
}

