/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;

@DefaultCoder(value=AggregateCoder.class)
public class Aggregate {
    private final long bytesIn;
    private final long bytesOut;
    private final String hostname;
    private final String hostname2;
    private final boolean congestionEncountered;
    private final boolean nonEcnCapableTransport;

    public Aggregate(long bytesIn, long bytesOut, String hostname, String hostname2, boolean ce, boolean nonEct) {
        this.bytesIn = bytesIn;
        this.bytesOut = bytesOut;
        this.hostname = hostname;
        this.hostname2 = hostname2;
        this.congestionEncountered = ce;
        this.nonEcnCapableTransport = nonEct;
    }

    public Aggregate(long bytesIn, long bytesOut, String hostname, String hostname2, Integer ecn) {
        this.bytesIn = bytesIn;
        this.bytesOut = bytesOut;
        this.hostname = hostname;
        this.hostname2 = hostname2;
        if (ecn != null) {
            this.congestionEncountered = ecn == 3;
            this.nonEcnCapableTransport = ecn == 0;
        } else {
            this.congestionEncountered = false;
            this.nonEcnCapableTransport = true;
        }
    }

    public Aggregate withHostname(String hostname) {
        return new Aggregate(this.bytesIn, this.bytesOut, hostname, null, this.congestionEncountered, this.nonEcnCapableTransport);
    }

    public static Aggregate merge(Aggregate a, Aggregate b) {
        return new Aggregate(a.bytesIn + b.bytesIn, a.bytesOut + b.bytesOut, Strings.isNullOrEmpty((String)a.hostname) ? b.hostname : (Strings.isNullOrEmpty((String)b.hostname) || a.hostname.compareTo(b.hostname) < 0 ? a.hostname : b.hostname), Strings.isNullOrEmpty((String)a.hostname2) ? b.hostname2 : (Strings.isNullOrEmpty((String)b.hostname2) || a.hostname2.compareTo(b.hostname2) < 0 ? a.hostname2 : b.hostname2), a.congestionEncountered || b.congestionEncountered, a.nonEcnCapableTransport || b.nonEcnCapableTransport);
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHostname2() {
        return this.hostname2;
    }

    public long getBytes() {
        return this.bytesIn + this.bytesOut;
    }

    public boolean isCongestionEncountered() {
        return this.congestionEncountered;
    }

    public boolean isNonEcnCapableTransport() {
        return this.nonEcnCapableTransport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Aggregate)) {
            return false;
        }
        Aggregate flowBytes = (Aggregate)o;
        return this.bytesIn == flowBytes.bytesIn && this.bytesOut == flowBytes.bytesOut && this.congestionEncountered == flowBytes.congestionEncountered && this.nonEcnCapableTransport == flowBytes.nonEcnCapableTransport && Objects.equals(this.hostname, flowBytes.hostname) && Objects.equals(this.hostname2, flowBytes.hostname2);
    }

    public int hashCode() {
        return Objects.hash(this.bytesIn, this.bytesOut, this.hostname, this.hostname2, this.congestionEncountered, this.nonEcnCapableTransport);
    }

    public String toString() {
        return "Aggregate{bytesIn=" + this.bytesIn + ", bytesOut=" + this.bytesOut + ", hostname='" + this.hostname + "', congestionEncountered=" + this.congestionEncountered + ", nonEcnCapableTransport=" + this.nonEcnCapableTransport + "}";
    }

    public static class AggregateCoder
    extends AtomicCoder<Aggregate> {
        private final Coder<Long> LONG_CODER = VarLongCoder.of();
        private final Coder<String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
        private final Coder<Boolean> BOOLEAN_CODER = BooleanCoder.of();

        public void encode(Aggregate value, OutputStream outStream) throws IOException {
            this.LONG_CODER.encode((Object)value.bytesIn, outStream);
            this.LONG_CODER.encode((Object)value.bytesOut, outStream);
            this.STRING_CODER.encode((Object)value.hostname, outStream);
            this.STRING_CODER.encode((Object)value.hostname2, outStream);
            this.BOOLEAN_CODER.encode((Object)value.congestionEncountered, outStream);
            this.BOOLEAN_CODER.encode((Object)value.nonEcnCapableTransport, outStream);
        }

        public Aggregate decode(InputStream inStream) throws IOException {
            return new Aggregate((Long)this.LONG_CODER.decode(inStream), (Long)this.LONG_CODER.decode(inStream), (String)this.STRING_CODER.decode(inStream), (String)this.STRING_CODER.decode(inStream), (Boolean)this.BOOLEAN_CODER.decode(inStream), (Boolean)this.BOOLEAN_CODER.decode(inStream));
        }

        public boolean consistentWithEquals() {
            return true;
        }
    }
}

