/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import com.google.gson.Gson;

public class CompoundKeyData {
    private static Gson GSON = new Gson();
    public final String foreignSource;
    public final String foreignId;
    public final int nodeId;
    public final int ifIndex;
    public final int dscp;
    public final String application;
    public final String address;
    public final String location;
    public final Integer protocol;
    public final String largerAddress;

    public CompoundKeyData(Builder builder) {
        this.foreignSource = builder.foreignSource;
        this.foreignId = builder.foreignId;
        this.nodeId = builder.nodeId;
        this.ifIndex = builder.ifIndex;
        this.dscp = builder.dscp;
        this.application = builder.application;
        this.address = builder.address;
        this.location = builder.location;
        this.protocol = builder.protocol;
        this.largerAddress = builder.largerAddress;
    }

    public String getConversationKey() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(GSON.toJson((Object)this.location)).append(',').append(this.protocol).append(',').append(GSON.toJson((Object)this.address)).append(',').append(GSON.toJson((Object)this.largerAddress)).append(',').append(GSON.toJson((Object)this.application)).append(']');
        return sb.toString();
    }

    public static class Builder {
        public String foreignSource;
        public String foreignId;
        public int nodeId;
        public int ifIndex;
        public int dscp;
        public String application;
        public String address;
        public String location;
        public Integer protocol;
        public String largerAddress;

        public Builder() {
        }

        public Builder(CompoundKeyData data) {
            this.foreignSource = data.foreignSource;
            this.foreignId = data.foreignId;
            this.nodeId = data.nodeId;
            this.ifIndex = data.ifIndex;
            this.dscp = data.dscp;
            this.application = data.application;
            this.address = data.address;
            this.location = data.location;
            this.protocol = data.protocol;
            this.largerAddress = data.largerAddress;
        }

        public Builder withAddress(String address) {
            this.address = address;
            return this;
        }

        public CompoundKeyData build() {
            return new CompoundKeyData(this);
        }
    }
}

