/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.opennms.nephron.CompoundKeyData;
import org.opennms.nephron.MissingFieldsException;
import org.opennms.nephron.cortex.TimeSeriesBuilder;
import org.opennms.nephron.elastic.ExporterNode;
import org.opennms.nephron.elastic.FlowSummary;
import org.opennms.netmgt.flows.persistence.model.Direction;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;
import org.opennms.netmgt.flows.persistence.model.NodeInfo;

public abstract class RefType {
    private static final Coder<String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final Coder<Integer> INT_CODER = NullableCoder.of((Coder)VarIntCoder.of());
    public static final RefType EXPORTER_PART = new RefType(){

        @Override
        public void encode(CompoundKeyData data, OutputStream os) throws IOException {
            INT_CODER.encode((Object)data.nodeId, os);
            STRING_CODER.encode((Object)data.foreignSource, os);
            STRING_CODER.encode((Object)data.foreignId, os);
        }

        @Override
        public void decode(CompoundKeyData.Builder builder, InputStream is) throws IOException {
            builder.nodeId = (Integer)INT_CODER.decode(is);
            builder.foreignSource = (String)STRING_CODER.decode(is);
            builder.foreignId = (String)STRING_CODER.decode(is);
        }

        @Override
        public void create(CompoundKeyData.Builder builder, FlowDocument flow) throws MissingFieldsException {
            if (!flow.hasExporterNode()) {
                throw new MissingFieldsException("exporterNode", flow);
            }
            NodeInfo exporterNode = flow.getExporterNode();
            builder.nodeId = exporterNode.getNodeId();
            if (!Strings.isNullOrEmpty((String)exporterNode.getForeignSource()) && !Strings.isNullOrEmpty((String)exporterNode.getForeginId())) {
                builder.foreignSource = exporterNode.getForeignSource();
                builder.foreignId = exporterNode.getForeginId();
            }
        }

        @Override
        public void populate(CompoundKeyData data, FlowSummary summary) {
            ExporterNode exporterNode = new ExporterNode();
            exporterNode.setNodeId(data.nodeId);
            exporterNode.setForeignSource(data.foreignSource);
            exporterNode.setForeignId(data.foreignId);
            summary.setExporter(exporterNode);
        }

        @Override
        public void populate(CompoundKeyData data, boolean exporterAndInterfaceAsLabels, TimeSeriesBuilder builder) {
            if (exporterAndInterfaceAsLabels) {
                builder.addLabel("nodeId", data.nodeId);
            }
        }

        @Override
        public void groupedByKey(CompoundKeyData data, StringBuilder sb) {
            if (data.foreignSource != null) {
                sb.append(data.foreignSource).append(':').append(data.foreignId);
            } else {
                sb.append(data.nodeId);
            }
        }

        @Override
        public boolean isCompleteConversationRef(CompoundKeyData data) {
            return false;
        }

        @Override
        public boolean equals(CompoundKeyData d1, CompoundKeyData d2) {
            return d1.nodeId == d2.nodeId && Objects.equals(d1.foreignId, d2.foreignId) && Objects.equals(d1.foreignSource, d2.foreignSource);
        }

        @Override
        public int hashCode(CompoundKeyData d) {
            return Objects.hash(d.nodeId, d.foreignId, d.foreignSource);
        }
    };
    public static final RefType INTERFACE_PART = new RefType(){

        @Override
        public void encode(CompoundKeyData data, OutputStream os) throws IOException {
            INT_CODER.encode((Object)data.ifIndex, os);
        }

        @Override
        public void decode(CompoundKeyData.Builder builder, InputStream is) throws IOException {
            builder.ifIndex = (Integer)INT_CODER.decode(is);
        }

        @Override
        public void create(CompoundKeyData.Builder builder, FlowDocument flow) throws MissingFieldsException {
            builder.ifIndex = Direction.INGRESS.equals((Object)flow.getDirection()) ? flow.getInputSnmpIfindex().getValue() : flow.getOutputSnmpIfindex().getValue();
        }

        @Override
        public void populate(CompoundKeyData data, FlowSummary summary) {
            summary.setIfIndex(data.ifIndex);
        }

        @Override
        public void populate(CompoundKeyData data, boolean exporterAndInterfaceAsLabels, TimeSeriesBuilder builder) {
            if (exporterAndInterfaceAsLabels) {
                builder.addLabel("ifIndex", data.ifIndex);
            }
        }

        @Override
        public void groupedByKey(CompoundKeyData data, StringBuilder sb) {
            sb.append(data.ifIndex);
        }

        @Override
        public boolean isCompleteConversationRef(CompoundKeyData data) {
            return false;
        }

        @Override
        public boolean equals(CompoundKeyData d1, CompoundKeyData d2) {
            return d1.ifIndex == d2.ifIndex;
        }

        @Override
        public int hashCode(CompoundKeyData d) {
            return d.ifIndex;
        }
    };
    public static int DEFAULT_CODE = 0;
    public static final RefType DSCP_PART = new RefType(){

        @Override
        public void encode(CompoundKeyData data, OutputStream os) throws IOException {
            INT_CODER.encode((Object)data.dscp, os);
        }

        @Override
        public void decode(CompoundKeyData.Builder builder, InputStream is) throws IOException {
            builder.dscp = (Integer)INT_CODER.decode(is);
        }

        @Override
        public void create(CompoundKeyData.Builder builder, FlowDocument flow) throws MissingFieldsException {
            builder.dscp = flow.hasDscp() ? flow.getDscp().getValue() : DEFAULT_CODE;
        }

        @Override
        public void populate(CompoundKeyData data, FlowSummary summary) {
            summary.setDscp(data.dscp);
        }

        @Override
        public void populate(CompoundKeyData data, boolean exporterAndInterfaceAsLabels, TimeSeriesBuilder builder) {
            builder.addLabel("dscp", data.dscp);
        }

        @Override
        public void groupedByKey(CompoundKeyData data, StringBuilder sb) {
            sb.append(data.dscp);
        }

        @Override
        public boolean isCompleteConversationRef(CompoundKeyData data) {
            return false;
        }

        @Override
        public boolean equals(CompoundKeyData d1, CompoundKeyData d2) {
            return d1.dscp == d2.dscp;
        }

        @Override
        public int hashCode(CompoundKeyData d) {
            return d.dscp;
        }
    };
    public static final RefType APPLICATION_PART = new RefType(){

        @Override
        public void encode(CompoundKeyData data, OutputStream os) throws IOException {
            STRING_CODER.encode((Object)data.application, os);
        }

        @Override
        public void decode(CompoundKeyData.Builder builder, InputStream is) throws IOException {
            builder.application = (String)STRING_CODER.decode(is);
        }

        @Override
        public void create(CompoundKeyData.Builder builder, FlowDocument flow) {
            String application = flow.getApplication();
            builder.application = Strings.isNullOrEmpty((String)application) ? "__unknown" : application;
        }

        @Override
        public void populate(CompoundKeyData data, FlowSummary summary) {
            summary.setApplication(data.application);
        }

        @Override
        public void populate(CompoundKeyData data, boolean exporterAndInterfaceAsLabels, TimeSeriesBuilder builder) {
            builder.addLabel("application", data.application);
        }

        @Override
        public void groupedByKey(CompoundKeyData data, StringBuilder sb) {
            sb.append(data.application);
        }

        @Override
        public boolean isCompleteConversationRef(CompoundKeyData data) {
            return false;
        }

        @Override
        public boolean equals(CompoundKeyData d1, CompoundKeyData d2) {
            return Objects.equals(d1.application, d2.application);
        }

        @Override
        public int hashCode(CompoundKeyData data) {
            return data.application != null ? data.application.hashCode() : 0;
        }
    };
    public static final RefType HOST_PART = new RefType(){

        @Override
        public void encode(CompoundKeyData data, OutputStream os) throws IOException {
            STRING_CODER.encode((Object)data.address, os);
        }

        @Override
        public void decode(CompoundKeyData.Builder builder, InputStream is) throws IOException {
            builder.address = (String)STRING_CODER.decode(is);
        }

        @Override
        public void create(CompoundKeyData.Builder builder, FlowDocument flow) throws MissingFieldsException {
            String src;
            builder.address = src = Strings.nullToEmpty((String)flow.getSrcAddress());
        }

        @Override
        public void populate(CompoundKeyData data, FlowSummary summary) {
            summary.setHostAddress(data.address);
        }

        @Override
        public void populate(CompoundKeyData data, boolean exporterAndInterfaceAsLabels, TimeSeriesBuilder builder) {
            builder.addLabel("host", data.address);
        }

        @Override
        public void groupedByKey(CompoundKeyData data, StringBuilder sb) {
            sb.append(data.address);
        }

        @Override
        public boolean isCompleteConversationRef(CompoundKeyData data) {
            return false;
        }

        @Override
        public boolean equals(CompoundKeyData d1, CompoundKeyData d2) {
            return Objects.equals(d1.address, d2.address);
        }

        @Override
        public int hashCode(CompoundKeyData data) {
            return data.address != null ? data.address.hashCode() : 0;
        }
    };
    public static final RefType CONVERSATION_PART = new RefType(){

        @Override
        public void encode(CompoundKeyData data, OutputStream os) throws IOException {
            STRING_CODER.encode((Object)data.location, os);
            INT_CODER.encode((Object)data.protocol, os);
            STRING_CODER.encode((Object)data.address, os);
            STRING_CODER.encode((Object)data.largerAddress, os);
            STRING_CODER.encode((Object)data.application, os);
        }

        @Override
        public void decode(CompoundKeyData.Builder builder, InputStream is) throws IOException {
            builder.location = (String)STRING_CODER.decode(is);
            builder.protocol = (Integer)INT_CODER.decode(is);
            builder.address = (String)STRING_CODER.decode(is);
            builder.largerAddress = (String)STRING_CODER.decode(is);
            builder.application = (String)STRING_CODER.decode(is);
        }

        @Override
        public void create(CompoundKeyData.Builder builder, FlowDocument flow) throws MissingFieldsException {
            String dst;
            builder.location = flow.getLocation();
            builder.protocol = flow.hasProtocol() ? Integer.valueOf(flow.getProtocol().getValue()) : null;
            String src = Strings.nullToEmpty((String)flow.getSrcAddress());
            if (src.compareTo(dst = Strings.nullToEmpty((String)flow.getDstAddress())) < 0) {
                builder.address = src;
                builder.largerAddress = dst;
            } else {
                builder.address = dst;
                builder.largerAddress = src;
            }
            String application = flow.getApplication();
            builder.application = Strings.isNullOrEmpty((String)application) ? "__unknown" : application;
        }

        @Override
        public void populate(CompoundKeyData data, FlowSummary summary) {
            summary.setConversationKey(data.getConversationKey());
        }

        @Override
        public void populate(CompoundKeyData data, boolean exporterAndInterfaceAsLabels, TimeSeriesBuilder builder) {
            builder.addLabel("location", data.location);
            builder.addLabel("protocol", data.protocol);
            builder.addLabel("host", data.address);
            builder.addLabel("host2", data.largerAddress);
            builder.addLabel("application", data.application);
        }

        @Override
        public void groupedByKey(CompoundKeyData data, StringBuilder sb) {
            sb.append(data.getConversationKey());
        }

        @Override
        public boolean isCompleteConversationRef(CompoundKeyData data) {
            return data.location != null && data.protocol != null && !Strings.isNullOrEmpty((String)data.address) && !Strings.isNullOrEmpty((String)data.largerAddress);
        }

        @Override
        public boolean equals(CompoundKeyData d1, CompoundKeyData d2) {
            return Objects.equals(d1.location, d2.location) && Objects.equals(d1.protocol, d2.protocol) && Objects.equals(d1.address, d2.address) && Objects.equals(d1.largerAddress, d2.largerAddress) && Objects.equals(d1.application, d2.application);
        }

        @Override
        public int hashCode(CompoundKeyData data) {
            return Objects.hash(data.location, data.protocol, data.address, data.largerAddress, data.application);
        }
    };

    public abstract void encode(CompoundKeyData var1, OutputStream var2) throws IOException;

    public abstract void decode(CompoundKeyData.Builder var1, InputStream var2) throws IOException;

    public abstract void create(CompoundKeyData.Builder var1, FlowDocument var2) throws MissingFieldsException;

    public abstract void populate(CompoundKeyData var1, FlowSummary var2);

    public abstract void populate(CompoundKeyData var1, boolean var2, TimeSeriesBuilder var3);

    public abstract void groupedByKey(CompoundKeyData var1, StringBuilder var2);

    public abstract boolean isCompleteConversationRef(CompoundKeyData var1);

    public abstract boolean equals(CompoundKeyData var1, CompoundKeyData var2);

    public abstract int hashCode(CompoundKeyData var1);
}

