/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;

public class UnalignedFixedWindows
extends NonMergingWindowFn<FlowDocument, IntervalWindow> {
    private final long size;

    public static UnalignedFixedWindows of(Duration size) {
        return new UnalignedFixedWindows(size);
    }

    public static long perNodeShift(int nodeId, long windowSize) {
        return (long)Math.abs(HashCommon.mix((int)nodeId)) % windowSize;
    }

    public static long windowStartForTimestamp(int nodeId, long windowSize, long timestamp) {
        long shift = UnalignedFixedWindows.perNodeShift(nodeId, windowSize);
        return timestamp - (timestamp - shift) % windowSize;
    }

    public static long windowNumber(int nodeId, long windowSize, long timestamp) {
        long shift = UnalignedFixedWindows.perNodeShift(nodeId, windowSize);
        return (timestamp - shift) / windowSize;
    }

    public static long windowStartForWindowNumber(int nodeId, long windowSize, long windowNumber) {
        long shift = UnalignedFixedWindows.perNodeShift(nodeId, windowSize);
        return shift + windowNumber * windowSize;
    }

    private UnalignedFixedWindows(Duration size) {
        this.size = Objects.requireNonNull(size).getMillis();
    }

    public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
        FlowDocument flow = (FlowDocument)c.element();
        long timestamp = c.timestamp().getMillis();
        long startMs = UnalignedFixedWindows.windowStartForTimestamp(flow.getExporterNode().getNodeId(), this.size, timestamp);
        Instant start = Instant.ofEpochMilli((long)startMs);
        IntervalWindow window = new IntervalWindow(start, start.plus(this.size));
        return Collections.singleton(window);
    }

    public boolean isCompatible(WindowFn<?, ?> other) {
        return Objects.equals((Object)this, other);
    }

    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    public WindowMappingFn<IntervalWindow> getDefaultWindowMappingFn() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UnalignedFixedWindows that = (UnalignedFixedWindows)((Object)o);
        return this.size == that.size;
    }

    public int hashCode() {
        return Objects.hash(this.size);
    }
}

