/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.opennms.nephron.CompoundKeyData;
import org.opennms.nephron.CompoundKeyType;
import org.opennms.nephron.RefType;
import org.opennms.nephron.cortex.TimeSeriesBuilder;
import org.opennms.nephron.elastic.FlowSummary;

@DefaultCoder(value=CompoundKeyCoder.class)
public class CompoundKey {
    public final CompoundKeyType type;
    public final CompoundKeyData data;
    private static final Coder<Integer> INT_CODER = NullableCoder.of((Coder)VarIntCoder.of());

    CompoundKey(CompoundKeyType type, CompoundKeyData data) {
        this.type = type;
        this.data = data;
    }

    public CompoundKeyType getType() {
        return this.type;
    }

    public CompoundKey getOuterKey() {
        return this.type.getParent() == null ? null : this.cast(this.type.getParent());
    }

    public CompoundKey cast(CompoundKeyType targetType) {
        return new CompoundKey(targetType, this.data);
    }

    public String groupedByKey() {
        return this.type.groupedByKey(this.data);
    }

    public void populate(FlowSummary flow) {
        this.type.populate(this.data, flow);
    }

    public void populate(TimeSeriesBuilder builder) {
        this.type.populate(this.data, builder);
    }

    public boolean isCompleteConversationKey() {
        RefType[] parts = this.type.getParts();
        int l = parts.length;
        return parts[l - 1].isCompleteConversationRef(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundKey that = (CompoundKey)o;
        if (this.type != that.type) {
            return false;
        }
        for (RefType refType : this.type.getParts()) {
            if (refType.equals(this.data, that.data)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.type.hashCode();
        for (RefType refType : this.type.getParts()) {
            hash = hash * 31 + refType.hashCode(this.data);
        }
        return hash;
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return this.type.groupedByKey(this.data);
    }

    public static class CompoundKeyCoder
    extends AtomicCoder<CompoundKey> {
        public void encode(CompoundKey value, OutputStream outStream) throws IOException {
            INT_CODER.encode((Object)value.getType().ordinal(), outStream);
            value.type.encode(value.data, outStream);
        }

        public CompoundKey decode(InputStream inStream) throws IOException {
            CompoundKeyType type = CompoundKeyType.values()[(Integer)INT_CODER.decode(inStream)];
            return type.decode(inStream);
        }

        public boolean consistentWithEquals() {
            return true;
        }
    }
}

