/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ArrayUtils;
import org.opennms.nephron.CompoundKey;
import org.opennms.nephron.CompoundKeyData;
import org.opennms.nephron.MissingFieldsException;
import org.opennms.nephron.RefType;
import org.opennms.nephron.cortex.TimeSeriesBuilder;
import org.opennms.nephron.elastic.FlowSummary;
import org.opennms.netmgt.flows.persistence.model.FlowDocument;

public enum CompoundKeyType {
    EXPORTER(true, null, RefType.EXPORTER_PART),
    EXPORTER_INTERFACE(true, EXPORTER, RefType.INTERFACE_PART),
    EXPORTER_INTERFACE_APPLICATION(false, EXPORTER_INTERFACE, RefType.APPLICATION_PART),
    EXPORTER_INTERFACE_CONVERSATION(false, EXPORTER_INTERFACE, RefType.CONVERSATION_PART),
    EXPORTER_INTERFACE_HOST(false, EXPORTER_INTERFACE, RefType.HOST_PART),
    EXPORTER_INTERFACE_TOS(true, EXPORTER_INTERFACE, RefType.DSCP_PART),
    EXPORTER_INTERFACE_TOS_APPLICATION(false, EXPORTER_INTERFACE_TOS, RefType.APPLICATION_PART),
    EXPORTER_INTERFACE_TOS_CONVERSATION(false, EXPORTER_INTERFACE_TOS, RefType.CONVERSATION_PART),
    EXPORTER_INTERFACE_TOS_HOST(false, EXPORTER_INTERFACE_TOS, RefType.HOST_PART);

    private final boolean totalNotTopK;
    private final CompoundKeyType parent;
    private final RefType[] parts;

    private CompoundKeyType(boolean totalNotTopK, CompoundKeyType parent, RefType ... parts) {
        this.totalNotTopK = totalNotTopK;
        this.parent = parent;
        this.parts = parent == null ? parts : (RefType[])ArrayUtils.addAll((Object[])parent.parts, (Object[])parts);
    }

    public boolean isTotalNotTopK() {
        return this.totalNotTopK;
    }

    public CompoundKeyType getParent() {
        return this.parent;
    }

    public RefType[] getParts() {
        return this.parts;
    }

    CompoundKey decode(InputStream is) throws IOException {
        CompoundKeyData.Builder builder = new CompoundKeyData.Builder();
        for (RefType refType : this.parts) {
            refType.decode(builder, is);
        }
        return new CompoundKey(this, builder.build());
    }

    void encode(CompoundKeyData data, OutputStream os) throws IOException {
        for (RefType refType : this.parts) {
            refType.encode(data, os);
        }
    }

    public CompoundKey create(FlowDocument flow) throws MissingFieldsException {
        CompoundKeyData.Builder builder = new CompoundKeyData.Builder();
        for (RefType refType : this.parts) {
            refType.create(builder, flow);
        }
        return new CompoundKey(this, builder.build());
    }

    void populate(CompoundKeyData data, FlowSummary flow) {
        flow.setGroupedBy(this);
        for (RefType refType : this.parts) {
            refType.populate(data, flow);
        }
    }

    void populate(CompoundKeyData data, TimeSeriesBuilder builder) {
        boolean exporterAndInterfaceAsLables;
        Object metricName;
        switch (this) {
            case EXPORTER: 
            case EXPORTER_INTERFACE: 
            case EXPORTER_INTERFACE_TOS: {
                metricName = this.name();
                exporterAndInterfaceAsLables = true;
                break;
            }
            case EXPORTER_INTERFACE_APPLICATION: {
                metricName = "BY_APP_" + data.nodeId + "_" + data.ifIndex;
                exporterAndInterfaceAsLables = false;
                break;
            }
            case EXPORTER_INTERFACE_TOS_APPLICATION: {
                metricName = "BY_TOS_AND_APP_" + data.nodeId + "_" + data.ifIndex;
                exporterAndInterfaceAsLables = false;
                break;
            }
            case EXPORTER_INTERFACE_HOST: {
                metricName = "BY_HOST_" + data.nodeId + "_" + data.ifIndex;
                exporterAndInterfaceAsLables = false;
                break;
            }
            case EXPORTER_INTERFACE_TOS_HOST: {
                metricName = "BY_TOS_AND_HOST_" + data.nodeId + "_" + data.ifIndex;
                exporterAndInterfaceAsLables = false;
                break;
            }
            case EXPORTER_INTERFACE_CONVERSATION: {
                metricName = "BY_CONV_" + data.nodeId + "_" + data.ifIndex;
                exporterAndInterfaceAsLables = false;
                break;
            }
            case EXPORTER_INTERFACE_TOS_CONVERSATION: {
                metricName = "BY_TOS_AND_CONV_" + data.nodeId + "_" + data.ifIndex;
                exporterAndInterfaceAsLables = false;
                break;
            }
            default: {
                throw new RuntimeException("unexpected compound key type: " + this);
            }
        }
        builder.setMetricName((String)metricName);
        for (RefType refType : this.parts) {
            refType.populate(data, exporterAndInterfaceAsLables, builder);
        }
    }

    String groupedByKey(CompoundKeyData data) {
        StringBuilder sb = new StringBuilder();
        for (RefType refType : this.parts) {
            if (sb.length() > 0) {
                sb.append('-');
            }
            refType.groupedByKey(data, sb);
        }
        return sb.toString();
    }
}

