/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;

public interface CortexOptions
extends PipelineOptions {
    @Description(value="Write URL for cortex (e.g. http://cortex:9009/api/v1/push). Setting this URL switches on Cortex persistence.")
    public String getCortexWriteUrl();

    public void setCortexWriteUrl(String var1);

    @Description(value="OrgId that is set in the X-Scope-OrgID header.")
    public String getCortexOrgId();

    public void setCortexOrgId(String var1);

    @Description(value="The maximum number of batched samples.")
    @Default.Integer(value=10000)
    public int getCortexMaxBatchSize();

    public void setCortexMaxBatchSize(int var1);

    @Description(value="The maximum number of bytes sent in one batch. (The actual number of sent bytes may be slightly larger.)")
    @Default.Integer(value=524288)
    public int getCortexMaxBatchBytes();

    public void setCortexMaxBatchBytes(int var1);

    @Description(value="Accumulation delay before samples are output to Cortex. Cortex accumulation is switched off if set to zero.")
    @Default.Long(value=0L)
    public long getCortexAccumulationDelayMs();

    public void setCortexAccumulationDelayMs(long var1);

    @Description(value="The addresses of those hosts that are included in the output of aggregations for hosts. The value is comma-separated list of addresses and address ranges. Host names and CIDR notation are supported.")
    @Default.String(value="")
    public String getCortexConsideredHosts();

    public void setCortexConsideredHosts(String var1);
}

