/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.network;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opennms.nephron.network.IPAddress;
import org.opennms.nephron.network.IPAddressRange;
import org.opennms.nephron.network.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpValue
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(IpValue.class);
    private final List<IPAddressRange> ranges;

    public static IpValue of(String input) {
        return IpValue.of(new StringValue(input));
    }

    public static IpValue of(StringValue input) {
        Objects.requireNonNull(input);
        if (input.isNullOrEmpty()) {
            throw new IllegalArgumentException("input may not be null or empty");
        }
        List<StringValue> actualValues = input.splitBy(",");
        ArrayList<IPAddressRange> ranges = new ArrayList<IPAddressRange>();
        for (StringValue eachValue : actualValues) {
            if (eachValue.isRanged()) {
                List<StringValue> rangedValues = eachValue.splitBy("-");
                if (rangedValues.size() != 2) {
                    LOG.warn("Received multiple ranges {}. Will only use {}", rangedValues, rangedValues.subList(0, 2));
                }
                for (StringValue rangedValue : rangedValues) {
                    if (!rangedValue.contains("/")) continue;
                    throw new IllegalArgumentException("Ranged value may not contain a CIDR expression");
                }
                ranges.add(new IPAddressRange(rangedValues.get(0).getValue(), rangedValues.get(1).getValue()));
                continue;
            }
            if (eachValue.getValue().contains("/")) {
                ranges.add(IpValue.parseCIDR(eachValue.getValue()));
                continue;
            }
            ranges.add(new IPAddressRange(eachValue.getValue()));
        }
        return new IpValue(ranges);
    }

    public IpValue(List<IPAddressRange> ranges) {
        this.ranges = ranges;
    }

    public boolean isInRange(String address) {
        return this.ranges.stream().anyMatch(r -> r.contains(address));
    }

    public List<IPAddressRange> getIpAddressRanges() {
        return this.ranges;
    }

    public static IPAddressRange parseCIDR(String cidr) {
        int slashIndex = cidr.indexOf(47);
        if (slashIndex == -1) {
            throw new IllegalArgumentException("Value is not a CIDR expression");
        }
        byte[] address = IpValue.toIpAddrBytes(cidr.substring(0, slashIndex));
        int mask = Integer.parseInt(cidr.substring(slashIndex + 1));
        byte[] lower = Arrays.copyOf(address, address.length);
        for (int i = lower.length - 1; i >= mask / 8; --i) {
            if (i * 8 >= mask) {
                lower[i] = 0;
                continue;
            }
            int n = i;
            lower[n] = (byte)(lower[n] & 255 << 8 - (mask - i * 8));
        }
        byte[] upper = Arrays.copyOf(address, address.length);
        for (int i = upper.length - 1; i >= mask / 8; --i) {
            if (i * 8 >= mask) {
                upper[i] = -1;
                continue;
            }
            int n = i;
            upper[n] = (byte)(upper[n] | 255 >> mask - i * 8);
        }
        return new IPAddressRange(IpValue.toIpAddrString(lower), IpValue.toIpAddrString(upper));
    }

    private static byte[] toIpAddrBytes(String dottedNotation) {
        return new IPAddress(dottedNotation).toOctets();
    }

    private static String toIpAddrString(byte[] addr) {
        return new IPAddress(addr).toDbString();
    }
}

