/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nephron.testing.benchmark;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Scanners;
import org.jparsec.pattern.CharPredicate;
import org.jparsec.pattern.Patterns;

public class CmdLineArgsProcessor {
    public static final CharPredicate IS_SIMPLE_VALUE = new CharPredicate(){

        public boolean isChar(char c) {
            return !Character.isWhitespace(c) && c != '(' && c != ')' && c != '&' && c != '|';
        }

        public String toString() {
            return "no-ws";
        }
    };
    static final Parser<Void> ddash = Scanners.string((String)"--");
    private static final Parser<Void> relevantWhitespace = Scanners.WHITESPACES.notFollowedBy(ddash.or(Scanners.isChar((char)'(')));
    static final Parser<Void> equals = Scanners.isChar((char)'=');
    static final Parser<Void> open = CmdLineArgsProcessor.withSurroundingWhitespace(Scanners.isChar((char)'('));
    static final Parser<Void> close = Scanners.WHITESPACES.optional(null).next(Scanners.isChar((char)')')).followedBy(relevantWhitespace.optional(null));
    static final Parser<Void> and = Parsers.or(CmdLineArgsProcessor.withSurroundingWhitespace(Scanners.isChar((char)'&')), (Parser)Scanners.WHITESPACES, (Parser)Scanners.isChar((char)'(').peek(), (Parser)ddash.peek());
    static final Parser<Void> or = CmdLineArgsProcessor.withSurroundingWhitespace(Scanners.isChar((char)'|'));
    static final Parser<Void> hash = CmdLineArgsProcessor.withSurroundingWhitespace(Scanners.isChar((char)'#'));
    static final Parser<String> valueAlternative = Scanners.notAmong((String)"#|)").many().source();
    static final Parser<ArgValue> singleArgValueParser = Patterns.many((CharPredicate)IS_SIMPLE_VALUE).toScanner("value").source().map(string -> new ArgValue.Simple((String)string));
    static final Parser<ArgValue> alternativesArgValueParser = open.next(valueAlternative.sepBy1(or)).followedBy(close).map(list -> new ArgValue.Alternatives((List<String>)list));
    static final Parser<Long> longParser = Scanners.isChar((char)'-').optional(null).next(Scanners.among((String)"0123456789").many()).source().map(s -> Long.parseLong(s));
    static final Parser<ArgValue> stepsArgValueParser = open.next(longParser.sepBy1(hash)).followedBy(close).map(list -> new ArgValue.Steps((List<Long>)list));
    static final Parser<ArgValue> argValueParser = alternativesArgValueParser.or(stepsArgValueParser).or(singleArgValueParser);
    static final Parser<Args> singleArgParser = ddash.next(Parsers.pair((Parser)Scanners.IDENTIFIER.source().followedBy(equals), argValueParser).map(pair -> Args.simpleOrInclude((String)pair.a, (ArgValue)pair.b)));
    static final Parser.Reference<Args> orRef = Parser.newReference();
    static final Parser<Args> baseArgParser = singleArgParser.or(open.next(orRef.lazy()).followedBy(close));
    static final Parser<Args> andArgParser = baseArgParser.sepBy1(and).map(list -> new Args.And((List<Args>)list)).label("ands");
    static final Parser<Args> orArgParser = andArgParser.sepBy1(or).map(list -> new Args.Or((List<? extends Args>)list)).label("ors");

    private static final <T> Parser<T> withSurroundingWhitespace(Parser<T> p) {
        return Scanners.WHITESPACES.optional(null).next(p).followedBy(Scanners.WHITESPACES.optional(null));
    }

    public static CmdLineArgs process(String ... strings) {
        ArrayList<Args> args = new ArrayList<Args>();
        String before = null;
        String after = null;
        String output = null;
        int idx = 0;
        BiFunction<Integer, String, String> nextArg = (i, option) -> {
            if (i == strings.length - 1) {
                throw new RuntimeException("missing argument after -" + option + " option");
            }
            return strings[i + 1];
        };
        while (idx < strings.length) {
            if ("-e".equals(strings[idx])) {
                String s = nextArg.apply(idx, "e");
                try {
                    args.add((Args)orArgParser.parse((CharSequence)s));
                }
                catch (Exception e) {
                    throw new RuntimeException("can not parse argument expression: " + s, e);
                }
                idx += 2;
                continue;
            }
            if ("-before".equals(strings[idx])) {
                before = nextArg.apply(idx, "before");
                idx += 2;
                continue;
            }
            if ("-after".equals(strings[idx])) {
                after = nextArg.apply(idx, "after");
                idx += 2;
                continue;
            }
            if ("-out".equals(strings[idx])) {
                output = nextArg.apply(idx, "out");
                idx += 2;
                continue;
            }
            try {
                args.add((Args)singleArgParser.parse((CharSequence)strings[idx]));
            }
            catch (Exception e) {
                throw new RuntimeException("can not parse simple argument expression: " + strings[idx], e);
            }
            ++idx;
        }
        Args pipelineArgs = args.size() == 1 ? (Args)args.get(0) : new Args.And(args);
        return new CmdLineArgs(before, after, output, pipelineArgs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Args include(String file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            Args args;
            String line;
            ArrayList<Args> args2 = new ArrayList<Args>();
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.isBlank() || trimmed.startsWith("#")) continue;
                Args arg = (Args)orArgParser.parse((CharSequence)trimmed);
                args2.add(arg);
            }
            if (args2.size() == 1) {
                args = (Args)args2.get(0);
                return args;
            }
            args = new Args.Or(args2);
            return args;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        orRef.set(orArgParser);
    }

    public static abstract class Params {
        public static And and(String ... strings) {
            return new And(Arrays.asList(strings));
        }

        public static Or or(String ... strings) {
            return new Or(Arrays.stream(strings).map(s -> Params.and(s)).collect(Collectors.toList()));
        }

        public abstract Params or(Params var1);

        public abstract Params and(Params var1);

        public abstract List<List<String>> expand();

        public static class And
        extends Params {
            private final List<String> values;

            public And(List<String> values) {
                this.values = values;
            }

            @Override
            public Params or(Params other) {
                if (other instanceof Or) {
                    return new Or(ListUtils.union(Collections.singletonList(this), ((Or)other).ands));
                }
                return new Or(Arrays.asList(this, (And)other));
            }

            @Override
            public Params and(Params other) {
                if (other instanceof Or) {
                    return new Or(((Or)other).ands.stream().map(a -> this.add((And)a)).collect(Collectors.toList()));
                }
                return this.add((And)other);
            }

            public And add(And other) {
                Set argNames = this.values.stream().map(And::argName).collect(Collectors.toSet());
                List filtered = other.values.stream().filter(v -> !argNames.contains(And.argName(v))).collect(Collectors.toList());
                return new And(ListUtils.union(this.values, filtered));
            }

            @Override
            public List<List<String>> expand() {
                return Collections.singletonList(this.values);
            }

            private static String argName(String s) {
                return s.substring(0, s.indexOf(61));
            }
        }

        public static class Or
        extends Params {
            private final List<And> ands;

            public Or(List<And> ands) {
                this.ands = ands;
            }

            @Override
            public Params or(Params other) {
                if (other instanceof Or) {
                    return new Or(ListUtils.union(this.ands, ((Or)other).ands));
                }
                return new Or(ListUtils.union(this.ands, Collections.singletonList((And)other)));
            }

            @Override
            public Params and(Params other) {
                if (other instanceof Or) {
                    return new Or(this.ands.stream().flatMap(al -> ((Or)other).ands.stream().map(ar -> al.add((And)ar))).collect(Collectors.toList()));
                }
                return new Or(this.ands.stream().map(a -> a.add((And)other)).collect(Collectors.toList()));
            }

            @Override
            public List<List<String>> expand() {
                return this.ands.stream().map(a -> a.values).collect(Collectors.toList());
            }
        }
    }

    public static abstract class ArgValue {
        public abstract List<String> expand();

        public static class Steps
        extends ArgValue {
            private final long from;
            private final long step;
            private final long count;

            public Steps(List<Long> list) {
                this.from = list.get(0);
                this.step = list.get(1);
                this.count = list.get(2);
            }

            @Override
            public List<String> expand() {
                ArrayList<String> res = new ArrayList<String>();
                int i = 0;
                while ((long)i < this.count) {
                    res.add(String.valueOf(this.from + (long)i * this.step));
                    ++i;
                }
                return res;
            }
        }

        public static class Alternatives
        extends ArgValue {
            private final List<String> strings;

            public Alternatives(List<String> strings) {
                this.strings = strings;
            }

            @Override
            public List<String> expand() {
                return this.strings;
            }
        }

        public static class Simple
        extends ArgValue {
            private final String string;

            public Simple(String string) {
                this.string = string;
            }

            @Override
            public List<String> expand() {
                return Collections.singletonList(this.string);
            }
        }
    }

    public static abstract class Args {
        public abstract Params eval();

        public static Args simpleOrInclude(String name, ArgValue value) {
            if ("include".equals(name)) {
                if (value instanceof ArgValue.Simple) {
                    return CmdLineArgsProcessor.include(((ArgValue.Simple)value).string);
                }
                if (value instanceof ArgValue.Alternatives) {
                    List includes = ((ArgValue.Alternatives)value).strings.stream().map(s -> CmdLineArgsProcessor.include(s)).collect(Collectors.toList());
                    return new Or(includes);
                }
                throw new RuntimeException("--include can not operate on step values");
            }
            return new Simple(name, value);
        }

        public static class Or
        extends Args {
            private final List<? extends Args> args;

            public Or(List<? extends Args> args) {
                this.args = args;
            }

            @Override
            public Params eval() {
                return this.args.stream().map(a -> a.eval()).reduce((p1, p2) -> p1.or((Params)p2)).orElse(Params.or(new String[0]));
            }
        }

        public static class And
        extends Args {
            private final List<Args> args;

            public And(List<Args> args) {
                this.args = args;
            }

            @Override
            public Params eval() {
                return this.args.stream().map(a -> a.eval()).reduce((p1, p2) -> p1.and((Params)p2)).orElse(Params.or(new String[0]));
            }
        }

        public static class Simple
        extends Args {
            private final String name;
            private final ArgValue value;

            public Simple(String name, ArgValue value) {
                this.name = name;
                this.value = value;
            }

            @Override
            public Params eval() {
                return new Params.Or(this.value.expand().stream().map(v -> Params.and("--" + this.name + "=" + v)).collect(Collectors.toList()));
            }
        }
    }

    public static class CmdLineArgs {
        public final String before;
        public final String after;
        public final String out;
        public final Args args;

        public CmdLineArgs(String before, String after, String out, Args args) {
            this.before = before;
            this.after = after;
            this.out = out;
            this.args = args;
        }
    }
}

